import React from 'react';
import { Head } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';
import VlogVideoForm from './form';

interface Props {
  categories: Record<string, string>;
  platforms: Record<string, string>;
}

const VlogVideoCreate = ({ categories, platforms }: Props) => {
  return (
    <AppLayout>
      <Head title="Add Vlog Video" />
      <VlogVideoForm categories={categories} platforms={platforms} />
    </AppLayout>
  );
};

export default VlogVideoCreate; 
