import { Button } from '@/frontend/components/ui/button';
import { showToast, showSuccessToast, showErrorToast, showWarningToast, showInfoToast, showPromiseToast } from '@/frontend/components/ui/toast-utils';
import AppLayout from '@/layouts/app-layout';
import { Head, Link } from '@inertiajs/react';

export default function ToastTest() {
    const handleSuccess = () => {
        showSuccessToast('Success!', 'This is a success message');
    };

    const handleError = () => {
        showErrorToast('Error!', 'This is an error message');
    };

    const handleWarning = () => {
        showWarningToast('Warning!', 'This is a warning message');
    };

    const handleInfo = () => {
        showInfoToast('Info!', 'This is an info message');
    };

    const handlePromise = () => {
        const promise = new Promise((resolve, reject) => {
            setTimeout(() => {
                if (Math.random() > 0.5) {
                    resolve('Promise resolved!');
                } else {
                    reject('Promise rejected!');
                }
            }, 2000);
        });

        showPromiseToast(promise, {
            loading: 'Loading...',
            success: 'Promise completed successfully!',
            error: 'Promise failed!'
        });
    };

    const handleCustom = () => {
        showToast.withAction(
            'Custom Toast',
            'This is a custom toast with an action',
            <Button size="sm" variant="outline">
                Action
            </Button>
        );
    };

    return (
        <AppLayout>
            <Head title="Toast Test" />
            
            <div className="container mx-auto p-6">
                <h1 className="text-3xl font-bold mb-6">Toast Notification Test</h1>
                
                <div className="space-y-6">
                    <div>
                        <h3 className="text-lg font-semibold mb-3">Client-side Toasts (JavaScript)</h3>
                        <div className="grid grid-cols-2 md:grid-cols-3 gap-4">
                            <Button onClick={handleSuccess} className="bg-green-600 hover:bg-green-700">
                                Success Toast
                            </Button>
                            
                            <Button onClick={handleError} className="bg-red-600 hover:bg-red-700">
                                Error Toast
                            </Button>
                            
                            <Button onClick={handleWarning} className="bg-yellow-600 hover:bg-yellow-700">
                                Warning Toast
                            </Button>
                            
                            <Button onClick={handleInfo} className="bg-blue-600 hover:bg-blue-700">
                                Info Toast
                            </Button>
                            
                            <Button onClick={handlePromise} className="bg-purple-600 hover:bg-purple-700">
                                Promise Toast
                            </Button>
                            
                            <Button onClick={handleCustom} className="bg-gray-600 hover:bg-gray-700">
                                Custom Toast
                            </Button>
                        </div>
                    </div>

                    <div>
                        <h3 className="text-lg font-semibold mb-3">Server-side Toasts (Laravel Session)</h3>
                        <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <Link 
                                href="/toast-test/success" 
                                className="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-center"
                            >
                                Success Session
                            </Link>
                            
                            <Link 
                                href="/toast-test/error" 
                                className="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded text-center"
                            >
                                Error Session
                            </Link>
                            
                            <Link 
                                href="/toast-test/warning" 
                                className="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded text-center"
                            >
                                Warning Session
                            </Link>
                            
                            <Link 
                                href="/toast-test/info" 
                                className="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-center"
                            >
                                Info Session
                            </Link>
                            
                            <Link 
                                href="/toast-test/redirect-back" 
                                className="bg-orange-600 hover:bg-orange-700 text-white px-4 py-2 rounded text-center"
                            >
                                Redirect Back Error
                            </Link>
                            
                            <Link 
                                href="/session-debug/error" 
                                className="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded text-center"
                            >
                                Session Debug Error
                            </Link>
                        </div>
                    </div>
                </div>

                <div className="mt-8 p-4 bg-gray-100 rounded-lg">
                    <h2 className="text-xl font-semibold mb-4">How to use in controllers:</h2>
                    <pre className="bg-gray-800 text-green-400 p-4 rounded text-sm overflow-x-auto">
{`// Using the ToastHelper
use App\\Helpers\\ToastHelper;

// Success message
return ToastHelper::success('Operation completed successfully!');

// Error message
return ToastHelper::error('Something went wrong!');

// Redirect with message
return ToastHelper::successToRoute('dashboard', 'Welcome back!');

// Traditional Laravel way (also works)
return redirect()->back()->with('success', 'Message here');
return redirect()->back()->with('error', 'Error message here');
return redirect()->back()->with('warning', 'Warning message here');
return redirect()->back()->with('info', 'Info message here');`}
                    </pre>
                </div>
            </div>
        </AppLayout>
    );
}
