import { Head, usePage } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';

export default function SessionDebug() {
    const { props } = usePage();
    
    return (
        <AppLayout>
            <Head title="Session Debug" />
            
            <div className="container mx-auto p-6">
                <h1 className="text-3xl font-bold mb-6">Session Debug</h1>
                
                <div className="space-y-4">
                    <div className="p-4 bg-gray-100 rounded-lg">
                        <h2 className="text-xl font-semibold mb-2">Raw Session Data:</h2>
                        <pre className="bg-gray-800 text-green-400 p-4 rounded text-sm overflow-x-auto">
                            {JSON.stringify(props.session, null, 2)}
                        </pre>
                    </div>
                    
                    <div className="p-4 bg-gray-100 rounded-lg">
                        <h2 className="text-xl font-semibold mb-2">All Props:</h2>
                        <pre className="bg-gray-800 text-green-400 p-4 rounded text-sm overflow-x-auto">
                            {JSON.stringify(props, null, 2)}
                        </pre>
                    </div>
                    
                    <div className="p-4 bg-gray-100 rounded-lg">
                        <h2 className="text-xl font-semibold mb-2">Session Messages:</h2>
                        <div className="space-y-2">
                            <p><strong>Success:</strong> {props.session?.success || 'None'}</p>
                            <p><strong>Error:</strong> {props.session?.error || 'None'}</p>
                            <p><strong>Warning:</strong> {props.session?.warning || 'None'}</p>
                            <p><strong>Info:</strong> {props.session?.info || 'None'}</p>
                            <p><strong>Toast:</strong> {props.session?.toast || 'None'}</p>
                        </div>
                    </div>
                </div>
            </div>
        </AppLayout>
    );
}
