import { Trophy, Users, Calendar, Award, Star, Target, Globe, ShieldCheck, TrendingUp, Camera, MapPin, Phone, Mail } from "lucide-react";

// Hero Section Data
export const heroSlides = [
  {
    id: 1,
    title: "The Milimus Tournament",
    subtitle: "Join the most prestigious football tournament in the region. Experience the thrill of competitive football with the best teams.",
    bgImage: "/images/hero-1.JPG",
    ctaPrimary: "Register Your Team",
    ctaSecondary: "View Fixtures"
  },
  {
    id: 2,
    title: "Where Legends Are Born",
    subtitle: "Compete against the finest teams in a tournament designed to showcase talent and determination.",
    bgImage: "/images/hero-2.JPG",
    ctaPrimary: "Join Tournament",
    ctaSecondary: "Tournament Rules"
  },
  {
    id: 3,
    title: "Championship Glory Awaits",
    subtitle: "The best teams compete for glory in a tournament that celebrates the beautiful game.",
    bgImage: "/images/hero.jpg",
    ctaPrimary: "Get Started",
    ctaSecondary: "Prize Pool"
  }
];

// News Articles Data
export const newsArticles = [
  {
    id: 1,
    title: "Registration Opens for The Milimus Tournament 2025",
    excerpt: "The Milimus Tournament 2025 registration is now officially open! Teams from across the region can submit their applications for the most prestigious football competition. With a record-breaking prize pool of Ksh. 70,000 and professional facilities, this year's tournament promises to be the biggest yet.",
    content: `
      <p>The Milimus Tournament 2025 registration is now officially open! Teams from across the region can submit their applications for the most prestigious football competition. With a record-breaking prize pool of Ksh. 70,000 and professional facilities, this year's tournament promises to be the biggest yet.</p>
      
      <h2>Early Bird Registration</h2>
      <p>Early bird registration is available until March 15th with special discounts for returning teams. This limited-time offer provides teams with:</p>
      <ul>
        <li>20% discount on registration fees</li>
        <li>Priority access to training facilities</li>
        <li>Exclusive merchandise package</li>
        <li>Guaranteed accommodation options</li>
      </ul>
      
      <h2>Tournament Format</h2>
      <p>The 2025 edition will feature 32 teams competing in a knockout format over three weeks. The tournament will include:</p>
      <ul>
        <li>Group stage matches (8 groups of 4 teams)</li>
        <li>Round of 16 knockout matches</li>
        <li>Quarter-finals and semi-finals</li>
        <li>Grand finale with trophy presentation</li>
      </ul>
      
      <h2>Prize Pool Distribution</h2>
      <p>The Ksh. 70,000 prize pool will be distributed as follows:</p>
      <ul>
        <li>1st Place: Ksh. 35,000 + Trophy</li>
        <li>2nd Place: Ksh. 20,000 + Medal</li>
        <li>3rd Place: Ksh. 10,000 + Medal</li>
        <li>4th Place: Ksh. 5,000</li>
      </ul>
      
      <h2>Registration Requirements</h2>
      <p>To register for The Milimus Tournament 2025, teams must provide:</p>
      <ul>
        <li>Complete team roster (18-22 players)</li>
        <li>Coach and assistant coach information</li>
        <li>Team manager contact details</li>
        <li>Medical certificates for all players</li>
        <li>Proof of age for all participants</li>
        <li>Registration fee payment</li>
      </ul>
      
      <h2>Important Dates</h2>
      <p>Mark your calendars for these key dates:</p>
      <ul>
        <li>Registration Opens: February 15, 2025</li>
        <li>Early Bird Deadline: March 15, 2025</li>
        <li>Final Registration Deadline: April 30, 2025</li>
        <li>Team Announcement: May 15, 2025</li>
        <li>Tournament Begins: June 1, 2025</li>
      </ul>
      
      <p>Don't miss your chance to be part of football history. Register your team today and compete for glory in The Milimus Tournament 2025!</p>
    `,
    category: "registration",
    author: "Tournament Committee",
    authorImage: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?auto=format&fit=crop&w=100&q=80",
    date: "2025-02-15",
    readTime: "5 min read",
    image: "https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=1200&q=80",
    tags: ["Registration", "Tournament", "2025", "Football"],
    views: 1247,
    likes: 89,
    featured: true
  },
  {
    id: 2,
    title: "Lwanda K FC Wins Milimus Tournament Cup 4th Edition",
    excerpt: "In a dramatic penalty shootout, Lwanda K FC emerged victorious over Kambiri FC to claim the Milimus Tournament Cup 4th Edition. The match was intense, with both teams displaying exceptional skill and determination. Fans were treated to a thrilling finale as Lwanda K FC clinched the win with a 4-3 score in penalties.",
    category: "teams",
    author: "Sports Reporter",
    date: "2025-01-4",
    readTime: "2 min read",
    image: "/images/lwanda-k-fc.jpg"
  },
  {
    id: 3,
    title: "Lwanda K FC Wins Milimus Tournament Cup 4th Edition",
    excerpt: "In a dramatic penalty shootout, Lwanda K FC emerged victorious over Kambiri FC to claim the Milimus Tournament Cup 4th Edition. The match was intense, with both teams displaying exceptional skill and determination. Fans were treated to a thrilling finale as Lwanda K FC clinched the win with a 4-3 score in penalties.",
    category: "teams",
    author: "Sports Reporter",
    date: "2025-01-4",
    readTime: "2 min read",
    image: "/images/price-giving.JPG"
  }
];

// News Categories
export const newsCategories = [
  { id: "all", name: "All News" },
  { id: "tournament", name: "Tournament Updates" },
  { id: "registration", name: "Registration" },
  { id: "teams", name: "Team News" },
  { id: "results", name: "Match Results" },
  { id: "announcements", name: "Announcements" }
];

// Gallery Data
export const galleryImages = [
  {
    id: 1,
    src: "/images/gallery-1.JPG",
    alt: "Football match action",
    category: "matches",
    edition: "4th",
    height: 1
  },
  {
    id: 2,
    src: "/images/gallery-2.JPG",
    alt: "Team celebration",
    category: "celebrations",
    edition: "3rd",
    height: 2
  },
  {
    id: 3,
    src: "/images/gallery-3.JPG",
    alt: "Trophy presentation",
    category: "awards",
    edition: "4th",
    height: 1
  },
  {
    id: 4,
    src: "/images/gallery-4.JPG",
    alt: "Stadium view",
    category: "venues",
    edition: "2nd",
    height: 2
  },
  {
    id: 5,
    src: "/images/gallery-5.JPG",
    alt: "Player training",
    category: "training",
    edition: "1st",
    height: 1
  },
  {
    id: 6,
    src: "/images/gallery-6.JPG",
    alt: "Fans cheering",
    category: "fans",
    edition: "4th",
    height: 2
  },
  {
    id: 7,
    src: "/images/gallery-7.JPG",
    alt: "Team photo",
    category: "teams",
    edition: "3rd",
    height: 1
  },
  {
    id: 8,
    src: "/images/gallery-8.JPG",
    alt: "Match highlights",
    category: "matches",
    edition: "2nd",
    height: 2
  },
  {
    id: 9,
    src: "/images/gallery-9.JPG",
    alt: "Match highlights",
    category: "matches",
    edition: "2nd",
  },
  {
    id: 10,
    src: "/images/gallery-10.JPG",
    alt: "Match highlights",
    category: "matches",
    edition: "2nd",
  },
  {
    id: 11,
    src: "/images/gallery-11.JPG",
    alt: "Match highlights",
    category: "matches",
    edition: "2nd",
  },
  {
    id: 12,
    src: "/images/gallery-12.JPG",
    alt: "Match highlights",
    category: "matches",
    edition: "2nd",
  }
  ];

export const galleryCategories = [
  { id: "all", name: "All Photos" },
  { id: "matches", name: "Matches" },
  { id: "celebrations", name: "Celebrations" },
  { id: "awards", name: "Awards" },
  { id: "venues", name: "Venues" },
  { id: "training", name: "Training" },
  { id: "fans", name: "Fans" },
  { id: "teams", name: "Teams" }
];

export const galleryEditions = [
  { id: "all", name: "All Editions" },
  { id: "1st", name: "1st Edition" },
  { id: "2nd", name: "2nd Edition" },
  { id: "3rd", name: "3rd Edition" },
  { id: "4th", name: "4th Edition" }
];

// Gallery Hero Slides
export const galleryHeroSlides = [
  {
    id: 1,
    title: "Tournament Highlights",
    subtitle: "Relive the most memorable moments from The Milimus Tournament",
    image: "https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=1920&q=80"
  },
  {
    id: 2,
    title: "Championship Glory",
    subtitle: "Celebrating the champions and their journey to victory",
    image: "https://images.unsplash.com/photo-1517649763962-0c623066013b?auto=format&fit=crop&w=1920&q=80"
  },
  {
    id: 3,
    title: "Behind the Scenes",
    subtitle: "Exclusive photos from training sessions and team preparations",
    image: "https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?auto=format&fit=crop&w=1920&q=80"
  }
];


// Tournament Highlights Data
export const tournamentHighlights = [
  {
    icon: "🏆",
    title: "4th Edition",
    description: "The biggest tournament yet",
    value: "2024",
    color: "text-yellow-600"
  },
  {
    icon: "⚽",
    title: "32 Teams",
    description: "From across the region",
    value: "32+",
    color: "text-green-600"
  },
  {
    icon: "💰",
    title: "€50,000 Prize Pool",
    description: "Record-breaking rewards",
    value: "€50K",
    color: "text-blue-600"
  },
  {
    icon: "🎯",
    title: "64 Matches",
    description: "Over 3 weeks",
    value: "64+",
    color: "text-red-600"
  }
];

// Tournament Achievements
export const tournamentAchievements = [
  { year: "2021", title: "1st Edition", description: "Inaugural tournament with 16 teams" },
  { year: "2022", title: "2nd Edition", description: "Expanded to 24 teams" },
  { year: "2023", title: "3rd Edition", description: "28 teams and international participation" },
  { year: "2024", title: "4th Edition", description: "32 teams and €50,000 prize pool" }
];

// Sponsors Data
export const sponsors = [
  {
    name: "SportTech Pro",
    category: "Equipment Partner",
    logo: "⚽",
    description: "Official equipment and training facilities provider",
    tier: "platinum"
  },
  {
    name: "MediaCorp",
    category: "Media Partner",
    logo: "📺",
    description: "Live streaming and broadcast coverage",
    tier: "gold"
  },
  {
    name: "EnergyBoost",
    category: "Nutrition Partner",
    logo: "🥤",
    description: "Official sports nutrition and hydration",
    tier: "silver"
  },
  {
    name: "SecureBank",
    category: "Financial Partner",
    logo: "🏦",
    description: "Official banking and payment solutions",
    tier: "bronze"
  }
];

// Testimonials Data
export const testimonials = [
  {
    name: "Carlos Rodriguez",
    role: "Team Captain",
    team: "FC Barcelona Academy",
    image: "👨‍💼",
    rating: 5,
    quote: "The Milimus Tournament provided us with the perfect platform to showcase our talent. The organization was professional and the competition was fierce.",
    achievement: "Champion 2023"
  },
  {
    name: "Maria Santos",
    role: "Coach",
    team: "Real Madrid Youth",
    image: "👩‍💼",
    rating: 5,
    quote: "As a coach, I appreciate the high standards and fair play promoted by this tournament. It's a great learning experience for young players.",
    achievement: "Runner-up 2022"
  },
  {
    name: "Ahmed Hassan",
    role: "Team Manager",
    team: "Al Ahly Academy",
    image: "👨‍💼",
    rating: 5,
    quote: "The facilities and hospitality were outstanding. The tournament organizers went above and beyond to ensure a great experience.",
    achievement: "Semi-finalist 2023"
  }
];

// Tournament Statistics
export const tournamentStats = [
  { label: "Satisfaction Rate", value: "98%", icon: "😊" },
  { label: "Teams Participated", value: "120+", icon: "👥" },
  { label: "Average Rating", value: "4.9/5", icon: "⭐" },
  { label: "Return Rate", value: "85%", icon: "🔄" }
];

// Call to Action Benefits
export const ctaBenefits = [
  { title: "Championship Glory", description: "Compete for prestigious trophies and recognition" },
  { title: "Professional Schedule", description: "Well-organized matches and training sessions" },
  { title: "Top Teams", description: "Face the best teams from across the region" }
];

export const highlights = [
  {
    icon: Trophy,
    title: "4th Edition",
    description: "The most prestigious tournament yet",
    value: "2025",
    color: "text-yellow-500"
  },
  {
    icon: Award,
    title: "Ksh. 70,000 Prize Pool",
    description: "Largest prize pool in tournament history",
    value: "Ksh. 70K",
    color: "text-purple-500"
  },
  {
    icon: Star,
    title: "Professional Referees",
    description: "FIFA-certified officials",
    value: "12+",
    color: "text-red-500"
  }
];

export const achievements = [
  {
      year: "2022",
    title: "1st Edition",
    description: "Inaugural tournament with 16 teams",
    participants: "16 Teams"
  },
  {
    year: "2023",
    title: "2nd Edition",
    description: "Expanded to 24 teams",
    participants: "24 Teams"
  },
  {
    year: "2024",
    title: "3rd Edition",
    description: "Full capacity with 32 teams",
    participants: "32 Teams"
  },
  {
    year: "2025",
    title: "4th Edition",
    description: "Record-breaking prize pool of Ksh. 70,000",
    participants: "32 Teams"
  }
]

export const stats = [
  { icon: Users, label: "Teams", value: "48+" },
  { icon: Calendar, label: "Matches", value: "120+" },
  { icon: Globe, label: "Countries", value: "5" },
  { icon: ShieldCheck, label: "Fair Play Awards", value: "10" },
  { icon: TrendingUp, label: "Years Running", value: "8" },
];

export const whyJoin = [
  { icon: Star, title: "Elite Competition", desc: "Face the best teams and players in the region." },
  { icon: Award, title: "Prestigious Prizes", desc: "Win trophies, medals, and recognition." },
  { icon: ShieldCheck, title: "Fair Play", desc: "We value integrity, safety, and respect above all." },
  { icon: Globe, title: "Diverse Community", desc: "Meet teams and fans from across the continent." },
];

export const organizers = [
  { name: "Jane Doe", role: "Tournament Director", img: "https://randomuser.me/api/portraits/women/68.jpg" },
  { name: "Michael Kimani", role: "Head of Operations", img: "https://randomuser.me/api/portraits/men/45.jpg" },
  { name: "Aisha Bello", role: "Community Manager", img: "https://randomuser.me/api/portraits/women/65.jpg" },
];

export const timeline = [
  { year: "2016", event: "Tournament Founded", icon: Trophy },
  { year: "2017", event: "First Regional Expansion", icon: Globe },
  { year: "2019", event: "Reached 30+ Teams", icon: Users },
];

export const fixtures = [
  {
    date: "2024-07-01",
    time: "15:00",
    teamA: { name: "Lions FC", logo: "/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png" },
    teamB: { name: "Eagles United", logo: "https://images.unsplash.com/photo-1517649763962-0c623066013b?auto=format&fit=crop&w=60&q=80" },
    venue: "Main Stadium",
    status: "completed",
    result: "2 - 1"
  },
  {
    date: "2024-07-02",
    time: "17:00",
    teamA: { name: "Sharks", logo: "https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=60&q=80" },
    teamB: { name: "Tigers", logo: "https://images.unsplash.com/photo-1464983953574-0892a716854b?auto=format&fit=crop&w=60&q=80" },
    venue: "Field B",
    status: "live",
    result: "1 - 1 (60')"
  },
  {
    date: "2024-07-03",
    time: "19:00",
    teamA: { name: "Panthers", logo: "https://images.unsplash.com/photo-1505843273132-bc5c6f7d2c5e?auto=format&fit=crop&w=60&q=80" },
    teamB: { name: "Falcons", logo: "/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png" },
    venue: "Main Stadium",
    status: "upcoming",
    result: "-"
  }
];

export const editions = [
  { id: "all", name: "All Editions" },
  { id: "1st", name: "1st Edition" },
  { id: "2nd", name: "2nd Edition" },
  { id: "3rd", name: "3rd Edition" },
  { id: "4th", name: "4th Edition" }
];

export const categories = [
  { id: "all", name: "All Photos" },
  { id: "action", name: "Action" },
  { id: "celebration", name: "Celebration" },
  { id: "venue", name: "Venue" },
  { id: "portrait", name: "Portrait" },
  { id: "ceremony", name: "Ceremony" },
  { id: "fans", name: "Fans" },
  { id: "training", name: "Training" },
  { id: "team", name: "Team" }
];

export const contactInfo = [
  { icon: Mail, label: "Email", value: "themilimusgerrytournamentcup@gmail.com" },
  { icon: Phone, label: "Phone", value: "+254 796 7396 996" },
  { icon: MapPin, label: "Location", value: "Ingolomosio, Shinyalu Constituency, Kakamega, Kenya" }
];
