import React from 'react';
import { Head } from '@inertiajs/react';
import Header from '@/components/frontend/layout/Header';
import Footer from '@/components/frontend/sections/Footer';

interface FrontendLayoutProps {
  children: React.ReactNode;
  title?: string;
  description?: string;
}

const FrontendLayout: React.FC<FrontendLayoutProps> = ({ 
  children, 
  title = 'Milimus Tournament',
  description = 'Professional Sports Tournament Management System'
}) => {
  return (
    <>
      <Head>
        <title>{title}</title>
        <meta name="description" content={description} />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      </Head>
      
      <div className="min-h-screen bg-background light">
        <Header />
        <main>
          {children}
        </main>
        <Footer />
      </div>
    </>
  );
};

export default FrontendLayout; 
