import AppLayoutTemplate from '@/layouts/app/app-sidebar-layout';
import { type BreadcrumbItem } from '@/types';
import { type ReactNode, useEffect } from 'react';
import { Toaster } from '@/frontend/components/ui/toaster';
import { showToast } from '@/frontend/components/ui/toast-utils';
import { usePage } from '@inertiajs/react';
import { TeamRegistrationAlert } from '@/components/TeamManager/TeamRegistrationAlert';

interface AppLayoutProps {
    children: ReactNode;
    breadcrumbs?: BreadcrumbItem[];
}

export default ({ children, breadcrumbs, ...props }: AppLayoutProps) => {
    const { props: pageProps } = usePage();
    
    useEffect(() => {
        // Debug: Log session data        
        // Show session messages as toasts
        if (pageProps?.session?.success) {
            console.log('Showing success toast:', pageProps.session.success);
            showToast.success(pageProps.session.success);
        }
        if (pageProps?.session?.error) {
            console.log('Showing error toast:', pageProps.session.error);
            showToast.error(pageProps.session.error);
        }
        if (pageProps?.session?.warning) {
            console.log('Showing warning toast:', pageProps.session.warning);
            showToast.warning(pageProps.session.warning);
        }
        if (pageProps?.session?.info) {
            console.log('Showing info toast:', pageProps.session.info);
            showToast.info(pageProps.session.info);
        }
        if (pageProps?.session?.toast) {
            console.log('Showing default toast:', pageProps.session.toast);
            showToast.default(pageProps.session.toast);
        }
    }, [pageProps?.session]);

    return (
        <AppLayoutTemplate breadcrumbs={breadcrumbs} {...props}>
            <div className="p-4">
                {/* Global Team Registration Alert for Team Managers */}
                <TeamRegistrationAlert teamRegistrationStatus={pageProps?.teamRegistrationStatus} />
                
                {children}
            </div>
            <Toaster />
        </AppLayoutTemplate>
    );
};
