import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { type ReactNode, useEffect } from 'react';
import { showToast } from '@/frontend/components/ui/toast-utils';
import { usePage } from '@inertiajs/react';

interface AdminLayoutProps {
    children: ReactNode;
    breadcrumbs?: BreadcrumbItem[];
}

export default ({ children, breadcrumbs, ...props }: AdminLayoutProps) => {
    const { props: pageProps } = usePage();
    
    useEffect(() => {
        // Show session messages as toasts
        const session = (pageProps?.session ?? {}) as {
            success?: string;
            error?: string;
            warning?: string;
            info?: string;
            toast?: string;
        };

        if (session.success) {
            showToast.success(session.success);
        }
        if (session.error) {
            showToast.error(session.error);
        }
        if (session.warning) {
            showToast.warning(session.warning);
        }
        if (session.info) {
            showToast.info(session.info);
        }
        if (session.toast) {
            showToast.default(session.toast);
        }
    }, [pageProps?.session]);

    return (
        <AppLayout breadcrumbs={breadcrumbs} {...props}>
            <div className="p-4">
                {children}
            </div>
        </AppLayout>
    );
};