import { useState, useEffect } from 'react';
import { usePage } from '@inertiajs/react';

interface PageProps {
  user?: {
    id: number;
    name: string;
    email: string;
    created_at: string;
  };
}

export function useOnboarding() {
  const { props } = usePage<PageProps>();
  const [showOnboarding, setShowOnboarding] = useState(false);

  useEffect(() => {
    // Check if user is new (created within last 24 hours) and hasn't seen onboarding
    if (props.user) {
      const userCreatedAt = new Date(props.user.created_at);
      const twentyFourHoursAgo = new Date(Date.now() - 24 * 60 * 60 * 1000);
      
      // Check if user was created recently and hasn't dismissed onboarding
      const isNewUser = userCreatedAt > twentyFourHoursAgo;
      const hasSeenOnboarding = localStorage.getItem(`onboarding_${props.user.id}`);
      
      if (isNewUser && !hasSeenOnboarding) {
        setShowOnboarding(true);
      }
    }
  }, [props.user]);

  const completeOnboarding = () => {
    if (props.user) {
      localStorage.setItem(`onboarding_${props.user.id}`, 'completed');
    }
    setShowOnboarding(false);
  };

  const dismissOnboarding = () => {
    if (props.user) {
      localStorage.setItem(`onboarding_${props.user.id}`, 'dismissed');
    }
    setShowOnboarding(false);
  };

  return {
    showOnboarding,
    completeOnboarding,
    dismissOnboarding,
  };
} 