import React from "react";
import { useNavigate } from "react-router-dom";
import { Input } from "../components/ui/input";
import { Button } from "../components/ui/button";
import Header from "../components/layout/Header";
import Footer from "../components/sections/Footer";

const Login = () => {
  const navigate = useNavigate();
  return (
    <>
      <Header />
      <div className="flex flex-col items-center justify-center min-h-[60vh] bg-gray-50">
        <div className="w-full max-w-md p-8 bg-white rounded shadow mt-8 mb-8">
          <h2 className="mb-6 text-2xl font-bold text-center">Login</h2>
          <form className="space-y-4">
            <Input type="email" placeholder="Email" required />
            <Input type="password" placeholder="Password" required />
            <Button type="submit" className="w-full">Login</Button>
          </form>
          <div className="mt-4 text-center">
            <span>Don't have an account? </span>
            <button className="text-blue-600 underline" onClick={() => navigate("/register")}>Register</button>
          </div>
        </div>
      </div>
      <Footer />
    </>
  );
};

export default Login; 