import Header from "../components/layout/Header";
import Footer from "../components/sections/Footer";

const HowToRegister = () => (
  <>
    <Header />
    <div className="min-h-[60vh] flex flex-col items-center justify-center bg-gray-50 py-12">
      <div className="max-w-2xl w-full bg-white rounded shadow p-8 mt-8 mb-8">
        <h1 className="text-3xl font-bold mb-4">How to Register</h1>
        <ol className="list-decimal pl-6 space-y-4 text-lg">
          <li>
            <strong>Go to the Registration Page:</strong> <br />
            Click on <span className="font-semibold">Register Team</span> in the navigation menu or <span className="font-semibold">Register Now</span> button.
          </li>
          <li>
            <strong>Fill in Team Details:</strong> <br />
            Enter your team name, email, phone, location, coach name, and year founded.
          </li>
          <li>
            <strong>Add Team Players:</strong> <br />
            Enter details for each player (name, email, phone, position). You can add or remove players as needed. A football team typically has 11 players.
          </li>
          <li>
            <strong>Add Team Officials:</strong> <br />
            Add your team officials (coach, manager, physio, etc.) with their contact details and roles.
          </li>
          <li>
            <strong>Make Payment:</strong> <br />
            Select your payment method, enter the transaction/reference number, and the amount paid.
          </li>
          <li>
            <strong>Submit Registration:</strong> <br />
            Review your details and click <span className="font-semibold">Finish</span> to complete your registration.
          </li>
        </ol>
        <div className="mt-8 text-base text-gray-600">
          For player registration, use the <span className="font-semibold">Player Registration</span> link in the navigation and fill in the required details.
        </div>
      </div>
    </div>
    <Footer />
  </>
);

export default HowToRegister; 