import React from "react"
import { Toaster } from "./toaster"

interface ToastProviderProps {
  children: React.ReactNode
}

export function ToastProvider({ children }: ToastProviderProps) {
  return (
    <>
      {children}
      <Toaster />
    </>
  )
}

// Export the toast utilities for easy access
export { showToast } from "./toast-utils"
export { useToast, toast } from "@/hooks/use-toast"
