import React from "react"
import { Button } from "./button"
import { showToast } from "./toast-utils"

export function ToastExamples() {
  const handleSuccessToast = () => {
    showToast.success("Success!", "Your action was completed successfully.")
  }

  const handleErrorToast = () => {
    showToast.error("Error!", "Something went wrong. Please try again.")
  }

  const handleWarningToast = () => {
    showToast.warning("Warning!", "Please check your input before proceeding.")
  }

  const handleInfoToast = () => {
    showToast.info("Information", "Here's some helpful information for you.")
  }

  const handlePromiseToast = () => {
    const mockPromise = new Promise((resolve, reject) => {
      setTimeout(() => {
        Math.random() > 0.5 ? resolve("Data loaded!") : reject("Failed to load data")
      }, 2000)
    })

    showToast.promise(mockPromise, {
      loading: "Loading data...",
      success: (data: any) => `Successfully loaded: ${data}`,
      error: (error: any) => `Failed to load: ${error}`,
    })
  }

  const handleCustomToast = () => {
    showToast.withAction(
      "Custom Toast",
      "This toast has a custom action button.",
      <Button size="sm" variant="outline">
        Action
      </Button>
    )
  }

  return (
    <div className="space-y-4 p-6">
      <h2 className="text-2xl font-bold">Toast Examples</h2>
      <div className="grid grid-cols-2 gap-4 md:grid-cols-3">
        <Button onClick={handleSuccessToast} variant="outline">
          Success Toast
        </Button>
        <Button onClick={handleErrorToast} variant="outline">
          Error Toast
        </Button>
        <Button onClick={handleWarningToast} variant="outline">
          Warning Toast
        </Button>
        <Button onClick={handleInfoToast} variant="outline">
          Info Toast
        </Button>
        <Button onClick={handlePromiseToast} variant="outline">
          Promise Toast
        </Button>
        <Button onClick={handleCustomToast} variant="outline">
          Custom Toast
        </Button>
      </div>
    </div>
  )
}
