import { Calendar, Clock, ArrowRight } from "lucide-react";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { newsArticles } from "@/lib/data";
import { Link } from "@inertiajs/react";

const NewsSection = () => {
  

  const formatDate = (dateString: string) => {
    const date = new Date(dateString);
    return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
  };

  return (
    <section id="news" className="py-20 bg-accent/30">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Header */}
        <div className="text-center mb-16 animate-fade-in-up">
          <h2 className="font-poppins font-bold text-3xl md:text-4xl text-foreground mb-4">
            Latest <span className="text-primary">News</span> & Updates
          </h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Stay updated with the latest tournament announcements, system updates, and important deadlines.
          </p>
        </div>

        {/* News Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {newsArticles.slice(0, 3).map((article: any, index: number) => (
            <Card 
              key={article.id} 
              className="sports-card overflow-hidden border-none bg-white shadow-lg"
              style={{ animationDelay: `${index * 150}ms` }}
            >
              <div className="relative">
                <img 
                  src={article.image} 
                  alt={article.title}
                  className="w-full h-48 object-cover"
                />
               
                <Badge 
                  variant="secondary" 
                  className="absolute top-4 right-4 bg-white/90 text-foreground"
                >
                  {article.category}
                </Badge>
              </div>

              <CardHeader className="pb-3">
                <div className="flex items-center text-sm text-muted-foreground mb-2">
                  <Calendar className="h-4 w-4 mr-1" />
                  {formatDate(article.date)}
                  <Clock className="h-4 w-4 ml-4 mr-1" />
                  2 min read
                </div>
                <CardTitle className="text-xl font-semibold leading-tight hover:text-primary transition-colors">
                  {article.title}
                </CardTitle>
              </CardHeader>

              <CardContent className="pt-0">
                <CardDescription className="text-muted-foreground mb-4">
                  {article.excerpt}
                </CardDescription>
                <Link href={`/news/${article.id}`}> 
                <Button variant="ghost" size="sm" className="text-primary hover:text-primary-dark p-0"  >
                  Read More
                  <ArrowRight className="h-4 w-4 ml-1" />
                </Button>
                </Link>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* View All Button */}
        <div className="text-center mt-12">
            <Link href="/news">
            <Button size="lg" variant="outline" className="rounded-full px-8">
              View All News
            </Button>
          </Link>
        </div>
      </div>
    </section>
  );
};

export default NewsSection;