import { useState } from "react";
import { Menu, X, Trophy, Users, Calendar, Award, Image, Newspaper } from "lucide-react";
import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import { useNavigate, NavLink } from "react-router-dom";

const Header = () => {
  const navigate = useNavigate();
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  const navigation = [
    { name: "Home", to: "/", icon: Trophy },
    { name: "About", to: "/about", icon: Award },
    { name: "Register Team", to: "/register", icon: Users },
    { name: "Fixtures", to: "/fixtures", icon: Calendar },
    { name: "Gallery", to: "/gallery", icon: Image },
    { name: "News", to: "/news", icon: Newspaper },
    { name: "Contact", to: "/contact", icon: Menu },
  ];

  return (
    <header className="bg-white/95 backdrop-blur-sm shadow-lg sticky top-0 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-16">
          {/* Logo */}
          <div className="flex items-center space-x-3">
            <img 
              src="/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png" 
              alt="Tournament Logo" 
              className="h-10 w-10 object-contain"
            />
          </div>

          {/* Desktop Navigation */}
          <nav className="hidden md:flex space-x-8">
            {navigation.map((item) => (
              <NavLink
                key={item.name}
                to={item.to}
                className={({ isActive }) =>
                  cn(
                    "flex items-center space-x-1 text-foreground transition-colors duration-200 font-medium hover:text-primary",
                    isActive && "text-primary font-bold"
                  )
                }
              >
                <item.icon className="h-4 w-4" />
                <span>{item.name}</span>
              </NavLink>
            ))}
          </nav>

          {/* CTA Buttons */}
          <div className="hidden md:flex items-center space-x-4">
            <Button variant="outline" size="sm" onClick={() => navigate("/login")}>Login</Button>
            <Button size="sm" className="gradient-primary" onClick={() => navigate("/register")}>Register</Button>
          </div>

          {/* Mobile menu button */}
          <div className="md:hidden">
            <Button
              variant="ghost"
              size="sm"
              onClick={() => setIsMenuOpen(!isMenuOpen)}
            >
              {isMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
            </Button>
          </div>
        </div>
      </div>

      {/* Mobile Navigation */}
      <div className={cn(
        "md:hidden transition-all duration-300 ease-in-out",
        isMenuOpen ? "max-h-screen opacity-100" : "max-h-0 opacity-0 overflow-hidden"
      )}>
        <div className="px-4 pt-2 pb-6 space-y-1 bg-white border-t">
          {navigation.map((item) => (
            <NavLink
              key={item.name}
              to={item.to}
              className={({ isActive }) =>
                cn(
                  "flex items-center space-x-3 px-3 py-2 text-foreground rounded-md transition-colors hover:text-primary hover:bg-accent",
                  isActive && "text-primary font-bold bg-accent"
                )
              }
              onClick={() => setIsMenuOpen(false)}
            >
              <item.icon className="h-5 w-5" />
              <span>{item.name}</span>
            </NavLink>
          ))}
          <div className="pt-4 space-y-2">
            <Button variant="outline" size="sm" className="w-full" onClick={() => navigate("/login")}>Login</Button>
            <Button size="sm" className="w-full gradient-primary" onClick={() => navigate("/register")}>Register</Button>
          </div>
        </div>
      </div>
    </header>
  );
};

export default Header;