import { BrowserRouter as Router, Routes, Route } from "react-router-dom";
import Login from "./pages/Login";
import Register from "./pages/Register";
import Index from "./pages/Index";
import NotFound from "./pages/NotFound";
import ForgotPassword from "./pages/ForgotPassword";
import About from "./pages/About";
import Fixtures from "./pages/Fixtures";
import Contact from "./pages/Contact";
import PlayerRegister from "./pages/PlayerRegister";
import Rules from "./pages/Rules";
import Prizes from "./pages/Prizes";
import Certificates from "./pages/Certificates";
import Help from "./pages/Help";
import FAQ from "./pages/FAQ";
import TechSupport from "./pages/TechSupport";
import Privacy from "./pages/Privacy";
import Terms from "./pages/Terms";
import Cookies from "./pages/Cookies";
import ResetPassword from "./pages/ResetPassword";
import HowToRegister from "./pages/HowToRegister";
import Gallery from "./pages/Gallery";
import News from "./pages/News";
import NewsArticle from "./pages/NewsArticle";

function App() {
  return (
    <Router>
      <div>
        <Routes>
          <Route path="/" element={<Index />} />
          <Route path="/about" element={<About />} />
          <Route path="/fixtures" element={<Fixtures />} />
          <Route path="/contact" element={<Contact />} />
          <Route path="/register" element={<Register />} />
          <Route path="/player-register" element={<PlayerRegister />} />
          <Route path="/rules" element={<Rules />} />
          <Route path="/prizes" element={<Prizes />} />
          <Route path="/certificates" element={<Certificates />} />
          <Route path="/help" element={<Help />} />
          <Route path="/faq" element={<FAQ />} />
          <Route path="/tech-support" element={<TechSupport />} />
          <Route path="/privacy" element={<Privacy />} />
          <Route path="/terms" element={<Terms />} />
          <Route path="/cookies" element={<Cookies />} />
          <Route path="/how-to-register" element={<HowToRegister />} />
          <Route path="/gallery" element={<Gallery />} />
          <Route path="/news" element={<News />} />
          <Route path="/news/:id" element={<NewsArticle />} />
          <Route path="/login" element={<Login />} />
          <Route path="/forgot-password" element={<ForgotPassword />} />
          <Route path="/reset-password" element={<ResetPassword />} />
          <Route path="*" element={<NotFound />} />
        </Routes>
      </div>
    </Router>
  );
} 

export default App;
