import React from 'react';
import { Badge } from '@/components/ui/badge';
import { cn } from '@/lib/utils';

interface CategoryBadgeProps {
    category: 'men' | 'women' | 'youth_male' | 'youth_female' | 'children';
    size?: 'sm' | 'md' | 'lg';
    showIcon?: boolean;
    showTooltip?: boolean;
    className?: string;
}

const categoryConfig = {
    men: {
        name: 'Men',
        icon: '👨',
        color: 'bg-blue-500 text-white hover:bg-blue-600',
        description: 'Men 18+ years',
    },
    women: {
        name: 'Women',
        icon: '👩',
        color: 'bg-pink-500 text-white hover:bg-pink-600',
        description: 'Women 18+ years',
    },
    youth_male: {
        name: 'Youth Male',
        icon: '🧑',
        color: 'bg-purple-500 text-white hover:bg-purple-600',
        description: 'Male 13-17 years',
    },
    youth_female: {
        name: 'Youth Female',
        icon: '👧',
        color: 'bg-purple-400 text-white hover:bg-purple-500',
        description: 'Female 13-17 years',
    },
    children: {
        name: 'Children',
        icon: '🧒',
        color: 'bg-green-500 text-white hover:bg-green-600',
        description: 'Under 13 years',
    },
};

const sizeClasses = {
    sm: 'text-xs px-2 py-0.5',
    md: 'text-sm px-3 py-1',
    lg: 'text-base px-4 py-2',
};

export function CategoryBadge({
    category,
    size = 'md',
    showIcon = true,
    showTooltip = true,
    className
}: CategoryBadgeProps) {
    const config = categoryConfig[category];
    
    if (!config) {
        return null;
    }

    const badge = (
        <Badge
            className={cn(
                config.color,
                sizeClasses[size],
                'font-semibold',
                className
            )}
        >
            {showIcon && <span className="mr-1">{config.icon}</span>}
            {config.name}
        </Badge>
    );

    if (showTooltip) {
        return (
            <span title={config.description}>
                {badge}
            </span>
        );
    }

    return badge;
}

