import React from 'react';
import { Card } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { Textarea } from '@/components/ui/textarea';
import { Trophy } from 'lucide-react';

interface BasicInfoStepProps {
  form: any;
  errors: any;
  onInputChange: (field: string, value: any) => void;
}

const BasicInfoStep: React.FC<BasicInfoStepProps> = ({
  form,
  errors,
  onInputChange,
}) => {
  return (
    <div className="space-y-6">
      <Card className="p-6">
                
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div className="md:col-span-2">
            <Label htmlFor="name">Tournament Name *</Label>
            <Input
              id="name"
              value={form.name}
              onChange={(e) => onInputChange('name', e.target.value)}
              className={errors.name ? 'border-red-500' : ''}
              placeholder="Enter tournament name"
            />
            {errors.name && <p className="text-red-500 text-sm mt-1">{errors.name}</p>}
          </div>

          

          <div>
            <Label htmlFor="organizer">Organizer</Label>
            <Input
              id="organizer"
              value={form.organizer}
              onChange={(e) => onInputChange('organizer', e.target.value)}
              placeholder="Tournament organizer"
            />
          </div>

          <div className="md:col-span-2">
            <Label htmlFor="description">Description</Label>
            <Textarea
              id="description"
              value={form.description}
              onChange={(e) => onInputChange('description', e.target.value)}
              placeholder="Describe your tournament..."
              rows={3}
            />
          </div>

          <div>
            <Label htmlFor="location">Location</Label>
            <Input
              id="location"
              value={form.location}
              onChange={(e) => onInputChange('location', e.target.value)}
              placeholder="e.g., Kakamega, Kenya"
            />
          </div>

          <div>
            <Label htmlFor="venue">Venue</Label>
            <Input
              id="venue"
              value={form.venue}
              onChange={(e) => onInputChange('venue', e.target.value)}
              placeholder="e.g., Kakamega County Stadium"
            />
          </div>

          <div>
            <Label htmlFor="contact_email">Contact Email</Label>
            <Input
              id="contact_email"
              type="email"
              value={form.contact_email}
              onChange={(e) => onInputChange('contact_email', e.target.value)}
              className={errors.contact_email ? 'border-red-500' : ''}
              placeholder="contact@tournament.com"
            />
            {errors.contact_email && <p className="text-red-500 text-sm mt-1">{errors.contact_email}</p>}
          </div>

          <div>
            <Label htmlFor="contact_phone">Contact Phone</Label>
            <Input
              id="contact_phone"
              value={form.contact_phone}
              onChange={(e) => onInputChange('contact_phone', e.target.value)}
              placeholder="07XX XXX XXX"
            />
          </div>

          <div>
            <Label htmlFor="website">Website</Label>
            <Input
              id="website"
              type="url"
              value={form.website}
              onChange={(e) => onInputChange('website', e.target.value)}
              className={errors.website ? 'border-red-500' : ''}
              placeholder="https://tournament-website.com"
            />
            {errors.website && <p className="text-red-500 text-sm mt-1">{errors.website}</p>}
          </div>

          <div>
            <Label htmlFor="visibility">Visibility *</Label>
            <Select value={form.visibility} onValueChange={(value) => onInputChange('visibility', value)}>
              <SelectTrigger className={errors.visibility ? 'border-red-500' : ''}>
                <SelectValue placeholder="Select visibility" />
              </SelectTrigger>
              <SelectContent>
                <SelectItem value="public">Public</SelectItem>
                <SelectItem value="private">Private</SelectItem>
                <SelectItem value="unlisted">Unlisted</SelectItem>
              </SelectContent>
            </Select>
            {errors.visibility && <p className="text-red-500 text-sm mt-1">{errors.visibility}</p>}
          </div>
        </div>
      </Card>
    </div>
  );
};

export default BasicInfoStep; 