import React from 'react';
import { Card } from '@/components/ui/card';
import { Label } from '@/components/ui/label';
import { Checkbox } from '@/components/ui/checkbox';
import { Shield } from 'lucide-react';

interface SettingsPrivacyStepProps {
  form: any;
  errors: any;
  onInputChange: (field: string, value: any) => void;
}

const SettingsPrivacyStep: React.FC<SettingsPrivacyStepProps> = ({
  form,
  errors,
  onInputChange,
}) => {
  return (
    <div className="space-y-6">
      <Card className="p-6">
        <div className="mb-6">
          <h3 className="text-lg font-semibold flex items-center gap-2">
            <Shield className="w-5 h-5" />
            Privacy Settings
          </h3>
          <p className="text-sm text-muted-foreground mt-1">
            Privacy settings and final review
          </p>
        </div>
        <div className="space-y-6">
          <div className="flex items-start space-x-3">
            <Checkbox
              id="is_public_profile"
              checked={form.is_public_profile}
              onCheckedChange={(checked) => onInputChange('is_public_profile', checked)}
            />
            <div className="space-y-1">
              <Label htmlFor="is_public_profile" className="text-sm font-medium">
                Public Profile
              </Label>
              <p className="text-sm text-muted-foreground">
                Allow other users to view your profile and statistics
              </p>
            </div>
          </div>
          
          <div className="flex items-start space-x-3">
            <Checkbox
              id="allow_messages"
              checked={form.allow_messages}
              onCheckedChange={(checked) => onInputChange('allow_messages', checked)}
            />
            <div className="space-y-1">
              <Label htmlFor="allow_messages" className="text-sm font-medium">
                Allow Messages
              </Label>
              <p className="text-sm text-muted-foreground">
                Allow other players to send you direct messages
              </p>
            </div>
          </div>
          
          <div className="flex items-start space-x-3 hidden">
            <Checkbox
              id="show_contact_info"
              checked={form.show_contact_info}
              onCheckedChange={(checked) => onInputChange('show_contact_info', checked)}
            />
            <div className="space-y-1">
              <Label htmlFor="show_contact_info" className="text-sm font-medium">
                Show Contact Information
              </Label>
              <p className="text-sm text-muted-foreground">
                Display your contact information on your public profile
              </p>
            </div>
          </div>
        </div>
      </Card>

      <Card className="p-6">
        <h3 className="text-lg font-semibold mb-4">Summary</h3>
        <div className="space-y-3 text-sm">
          <div className="flex justify-between">
            <span className="text-muted-foreground">Display Name:</span>
            <span className="font-medium">{form.display_name || 'Not set'}</span>
          </div>
          <div className="flex justify-between">
            <span className="text-muted-foreground">Player Type:</span>
            <span className="font-medium capitalize">{form.player_type?.replace('_', ' ') || 'Not set'}</span>
          </div>
          <div className="flex justify-between">
            <span className="text-muted-foreground">Experience Level:</span>
            <span className="font-medium capitalize">{form.experience_level || 'Not set'}</span>
          </div>
          <div className="flex justify-between">
            <span className="text-muted-foreground">Status:</span>
            <span className="font-medium capitalize">{form.status || 'Not set'}</span>
          </div>
          <div className="flex justify-between">
            <span className="text-muted-foreground">Profile Visibility:</span>
            <span className="font-medium">{form.is_public_profile ? 'Public' : 'Private'}</span>
          </div>
        </div>
      </Card>
    </div>
  );
};

export default SettingsPrivacyStep; 