import React from 'react';
import { Card } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Phone, Globe } from 'lucide-react';

interface ContactSocialStepProps {
  form: any;
  errors: any;
  onInputChange: (field: string, value: any) => void;
}

const ContactSocialStep: React.FC<ContactSocialStepProps> = ({
  form,
  errors,
  onInputChange,
}) => {
  return (
    <div className="space-y-6">
      <Card className="p-6">
        <div className="mb-6">
          <h3 className="text-lg font-semibold flex items-center gap-2">
            <Phone className="w-5 h-5" />
            Contact Information
          </h3>
          <p className="text-sm text-muted-foreground mt-1">
            Contact information and social media links
          </p>
        </div>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <Label htmlFor="phone">
              Phone <span className="text-red-500">*</span>
            </Label>
            <Input
              id="phone"
              value={form.phone}
              onChange={(e) => onInputChange('phone', e.target.value)}
              placeholder="07XX XXX XXX"
              className={!form.phone ? 'border-red-500' : ''}
              required
            />
            {!form.phone && (
              <p className="text-red-500 text-sm mt-1">Required for approval</p>
            )}
          </div>

          <div>
            <Label htmlFor="website">Website</Label>
            <Input
              id="website"
              value={form.website}
              onChange={(e) => onInputChange('website', e.target.value)}
              placeholder="https://example.com"
            />
          </div>
        </div>
      </Card>

      <Card className="p-6">
        <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
          <Globe className="w-5 h-5" />
          Social Media & Gaming
        </h3>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <Label htmlFor="discord_username">Discord Username</Label>
            <Input
              id="discord_username"
              value={form.discord_username}
              onChange={(e) => onInputChange('discord_username', e.target.value)}
              placeholder="username#1234"
            />
          </div>

          <div>
            <Label htmlFor="steam_id">Steam ID</Label>
            <Input
              id="steam_id"
              value={form.steam_id}
              onChange={(e) => onInputChange('steam_id', e.target.value)}
              placeholder="STEAM_0:1:12345678"
            />
          </div>

          <div>
            <Label htmlFor="twitch_username">Twitch Username</Label>
            <Input
              id="twitch_username"
              value={form.twitch_username}
              onChange={(e) => onInputChange('twitch_username', e.target.value)}
              placeholder="username"
            />
          </div>

          <div>
            <Label htmlFor="youtube_channel">YouTube Channel</Label>
            <Input
              id="youtube_channel"
              value={form.youtube_channel}
              onChange={(e) => onInputChange('youtube_channel', e.target.value)}
              placeholder="channel name or ID"
            />
          </div>

          <div>
            <Label htmlFor="twitter_handle">Twitter Handle</Label>
            <Input
              id="twitter_handle"
              value={form.twitter_handle}
              onChange={(e) => onInputChange('twitter_handle', e.target.value)}
              placeholder="@username"
            />
          </div>

          <div>
            <Label htmlFor="instagram_handle">Instagram Handle</Label>
            <Input
              id="instagram_handle"
              value={form.instagram_handle}
              onChange={(e) => onInputChange('instagram_handle', e.target.value)}
              placeholder="@username"
            />
          </div>
        </div>
      </Card>
    </div>
  );
};

export default ContactSocialStep; 