import React from 'react';
import { Label } from '@/components/ui/label';
import { Input } from '@/components/ui/input';
import { Textarea } from '@/components/ui/textarea';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';

interface BasicInfoStepProps {
  form: any;
  setForm: (form: any) => void;
  errors: any;
}

const BasicInfoStep: React.FC<BasicInfoStepProps> = ({ form, setForm, errors }) => {
  return (
    <div className="space-y-4">
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <Label htmlFor="name">Match Name *</Label>
          <Input
            id="name"
            value={form.name || ''}
            onChange={(e) => setForm({ ...form, name: e.target.value })}
            placeholder="Enter match name"
          />
          {errors.name && <div className="text-red-500 text-xs mt-1">{errors.name}</div>}
        </div>

        <div>
          <Label htmlFor="match_code">Match Code</Label>
          <Input
            id="match_code"
            value={form.match_code || ''}
            onChange={(e) => setForm({ ...form, match_code: e.target.value })}
            placeholder="Auto-generated if empty"
          />
          {errors.match_code && <div className="text-red-500 text-xs mt-1">{errors.match_code}</div>}
        </div>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <Label htmlFor="match_type">Match Type *</Label>
          <Select value={form.match_type || ''} onValueChange={(value) => setForm({ ...form, match_type: value })}>
            <SelectTrigger>
              <SelectValue placeholder="Select match type" />
            </SelectTrigger>
            <SelectContent>
              <SelectItem value="individual">Individual</SelectItem>
              <SelectItem value="team">Team</SelectItem>
              <SelectItem value="mixed">Mixed</SelectItem>
              <SelectItem value="group_stage">Group Stage</SelectItem>
              <SelectItem value="knockout_stage">Knockout Stage</SelectItem>
              <SelectItem value="semi_final">Semi Final</SelectItem>
              <SelectItem value="final">Final</SelectItem>
              <SelectItem value="ladies_final">Ladies Final</SelectItem>
              <SelectItem value="kids_special">Kids Special</SelectItem>
              <SelectItem value="ladies_special">Ladies Special</SelectItem>
              <SelectItem value="entertainment">Entertainment</SelectItem>
              <SelectItem value="consolation">Consolation</SelectItem>
              <SelectItem value="mens_final">Mens Final</SelectItem>
              <SelectItem value="wazee_final">Wazee Final</SelectItem>
            </SelectContent>
          </Select>
          {errors.match_type && <div className="text-red-500 text-xs mt-1">{errors.match_type}</div>}
        </div>

        <div>
          <Label htmlFor="format">Match Format *</Label>
          <Select value={form.format || ''} onValueChange={(value) => setForm({ ...form, format: value })}>
            <SelectTrigger>
              <SelectValue placeholder="Select format" />
            </SelectTrigger>
            <SelectContent>
              <SelectItem value="best_of_1">Best of 1</SelectItem>
              <SelectItem value="best_of_3">Best of 3</SelectItem>
              <SelectItem value="best_of_5">Best of 5</SelectItem>
              <SelectItem value="best_of_7">Best of 7</SelectItem>
              <SelectItem value="first_to_win">First to Win</SelectItem>
              <SelectItem value="time_limit">Time Limit</SelectItem>
            </SelectContent>
          </Select>
          {errors.format && <div className="text-red-500 text-xs mt-1">{errors.format}</div>}
        </div>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <Label htmlFor="best_of_games">Best of Games *</Label>
          <Input
            id="best_of_games"
            type="number"
            min="1"
            value={form.best_of_games || 1}
            onChange={(e) => setForm({ ...form, best_of_games: parseInt(e.target.value) })}
          />
          {errors.best_of_games && <div className="text-red-500 text-xs mt-1">{errors.best_of_games}</div>}
        </div>

        <div>
          <Label htmlFor="time_limit_minutes">Time Limit (minutes)</Label>
          <Input
            id="time_limit_minutes"
            type="number"
            min="1"
            value={form.time_limit_minutes || ''}
            onChange={(e) => setForm({ ...form, time_limit_minutes: e.target.value ? parseInt(e.target.value) : null })}
            placeholder="Optional"
          />
          {errors.time_limit_minutes && <div className="text-red-500 text-xs mt-1">{errors.time_limit_minutes}</div>}
        </div>
      </div>

      <div>
        <Label htmlFor="description">Description</Label>
        <Textarea
          id="description"
          value={form.description || ''}
          onChange={(e) => setForm({ ...form, description: e.target.value })}
          placeholder="Enter match description"
          rows={3}
        />
        {errors.description && <div className="text-red-500 text-xs mt-1">{errors.description}</div>}
      </div>

      <div>
        <Label htmlFor="notes">Notes</Label>
        <Textarea
          id="notes"
          value={form.notes || ''}
          onChange={(e) => setForm({ ...form, notes: e.target.value })}
          placeholder="Additional notes"
          rows={2}
        />
        {errors.notes && <div className="text-red-500 text-xs mt-1">{errors.notes}</div>}
      </div>
    </div>
  );
};

export default BasicInfoStep; 