import React from 'react';
import { usePage } from '@inertiajs/react';
import ImpersonationBanner from '@/components/ImpersonationBanner';

interface AppLayoutProps {
  children: React.ReactNode;
}

interface PageProps {
  auth: {
    user: any;
    impersonation?: {
      is_impersonating: boolean;
      impersonated_user: {
        id: number;
        name: string;
        email: string;
      };
      original_user: {
        id: number;
        name: string;
        email: string;
      };
    };
  };
}

const AppLayout: React.FC<AppLayoutProps> = ({ children }) => {
  const { auth } = usePage<PageProps>().props;
  const isImpersonating = auth.impersonation?.is_impersonating || false;

  return (
    <div className="min-h-screen bg-background">
      {/* Impersonation Banner */}
      {isImpersonating && auth.impersonation && (
        <ImpersonationBanner
          impersonatedUser={auth.impersonation.impersonated_user}
          originalUser={auth.impersonation.original_user}
        />
      )}
      
      {/* Main Content with conditional top padding */}
      <div 
        className={`p-6 ${isImpersonating ? 'pt-16' : ''}`}
        style={{ 
          minHeight: isImpersonating ? 'calc(100vh - 64px)' : '100vh' 
        }}
      >
        <div className="p-4">
          {children}
        </div>
      </div>
    </div>
  );
};

export default AppLayout;