import { TrendingUp } from "lucide-react";
import { Card, CardContent } from "@/components/ui/card";

interface TournamentHighlightsSectionProps {
  highlights: any[];
  achievements: any[];
  stats: any[];
}

const TournamentHighlightsSection = ({ highlights, achievements, stats }: TournamentHighlightsSectionProps) => {
  // Handle empty data
  const safeHighlights = highlights || [];
  const safeAchievements = achievements || [];
  const safeStats = stats || [];

  return (
    <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-foreground mb-4">
            Tournament <span className="text-primary">Highlights</span>
          </h2>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
            Discover what makes The Milimus Tournament the most prestigious football competition in the region
          </p>
        </div>

        {/* Highlights Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-20">
          {safeHighlights.map((highlight, index) => (
            <Card key={index} className="sports-card border-none bg-white/80 backdrop-blur-sm hover:shadow-xl transition-all duration-300">
              <CardContent className="p-6 text-center">
                <div className={`mx-auto mb-4 p-3 rounded-full bg-white/50 w-fit`}>
                  <div className={`text-2xl`}>{highlight.icon}</div>
                </div>
                <h3 className="text-xl font-semibold text-foreground mb-2">{highlight.title}</h3>
                <p className="text-muted-foreground mb-3">{highlight.description}</p>
                <div className={`text-3xl font-bold ${highlight.color}`}>{highlight.value}</div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Tournament Evolution */}
        <div className="bg-white/80 backdrop-blur-sm rounded-2xl p-8 shadow-xl">
          <div className="text-center mb-12">
            <h3 className="text-3xl font-bold text-foreground mb-4">
              Tournament <span className="text-primary">Evolution</span>
            </h3>
            <p className="text-lg text-muted-foreground">
              From humble beginnings to the region's premier football tournament
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {safeAchievements.map((achievement, index) => (
              <div key={index} className="relative">
                <div className="text-center p-6 rounded-xl bg-gradient-to-br from-primary/10 to-secondary/10 border border-primary/20">
                  <div className="text-4xl font-bold text-primary mb-2">{achievement.year}</div>
                  <h4 className="text-lg font-semibold text-foreground mb-2">{achievement.title}</h4>
                  <p className="text-sm text-muted-foreground mb-3">{achievement.description}</p>
                  <div className="text-sm font-medium text-primary">{achievement.participants}</div>
                </div>
                {index < achievements.length - 1 && (
                  <div className="hidden lg:block absolute top-1/2 -right-3 transform -translate-y-1/2">
                    <TrendingUp className="h-6 w-6 text-primary/50" />
                  </div>
                )}
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default TournamentHighlightsSection; 