import { Building2, Globe, Shield, Zap } from "lucide-react";
import { Card, CardContent } from "@/components/ui/card";

interface SponsorsSectionProps {
  sponsors: any[];
}

const SponsorsSection = ({ sponsors }: SponsorsSectionProps) => {
  // Handle empty sponsors
  const safeSponsors = sponsors || [];

  const getTierColor = (tier: string) => {
    switch (tier) {
      case "platinum":
        return "from-gray-400 to-gray-600";
      case "gold":
        return "from-yellow-400 to-yellow-600";
      case "silver":
        return "from-gray-300 to-gray-500";
      case "bronze":
        return "from-orange-400 to-orange-600";
      default:
        return "from-gray-400 to-gray-600";
    }
  };

  const getTierBadge = (tier: string) => {
    switch (tier) {
      case "platinum":
        return "Platinum Partner";
      case "gold":
        return "Gold Partner";
      case "silver":
        return "Silver Partner";
      case "bronze":
        return "Bronze Partner";
      default:
        return "Partner";
    }
  };

  return (
    <section className="py-20 bg-gradient-to-br from-gray-50 to-gray-100">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Header 
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-foreground mb-4">
            Our <span className="text-primary">Partners</span>
          </h2>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
            Proud to work with industry leaders who share our passion for football excellence
          </p>
        </div> */}

        {/* Sponsors Grid 
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
          {sponsors.map((sponsor, index) => (
            <Card key={index} className="sports-card border-none bg-white shadow-lg hover:shadow-xl transition-all duration-300">
              <CardContent className="p-6">
                <div className="text-center mb-4">
                  <div className="text-4xl mb-3">{sponsor.logo}</div>
                  <div className={`inline-block px-3 py-1 rounded-full text-xs font-semibold text-white bg-gradient-to-r ${getTierColor(sponsor.tier)}`}>
                    {getTierBadge(sponsor.tier)}
                  </div>
                </div>
                <h3 className="text-xl font-semibold text-foreground text-center mb-2">{sponsor.name}</h3>
                <p className="text-sm text-primary font-medium text-center mb-3">{sponsor.category}</p>
                <p className="text-muted-foreground text-center text-sm">{sponsor.description}</p>
              </CardContent>
            </Card>
          ))}
        </div> */}

        {/* Partnership Benefits */}
        <div className="bg-white rounded-2xl p-8 shadow-xl">
          <div className="text-center mb-12">
            <h3 className="text-3xl font-bold text-foreground mb-4">
              Partnership <span className="text-primary">Benefits</span>
            </h3>
            <p className="text-lg text-muted-foreground">
              Why leading brands choose to partner with The Milimus Tournament
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="text-center p-6">
              <div className="mx-auto mb-4 p-3 rounded-full bg-primary/10 w-fit">
                <Globe className="h-8 w-8 text-primary" />
              </div>
              <h4 className="text-lg font-semibold text-foreground mb-2">Global Exposure</h4>
              <p className="text-sm text-muted-foreground">Reach millions of football fans worldwide</p>
            </div>

            <div className="text-center p-6">
              <div className="mx-auto mb-4 p-3 rounded-full bg-primary/10 w-fit">
                <Building2 className="h-8 w-8 text-primary" />
              </div>
              <h4 className="text-lg font-semibold text-foreground mb-2">Brand Integration</h4>
              <p className="text-sm text-muted-foreground">Seamless integration across all touchpoints</p>
            </div>

            <div className="text-center p-6">
              <div className="mx-auto mb-4 p-3 rounded-full bg-primary/10 w-fit">
                <Shield className="h-8 w-8 text-primary" />
              </div>
              <h4 className="text-lg font-semibold text-foreground mb-2">Quality Assurance</h4>
              <p className="text-sm text-muted-foreground">Premium tournament standards and professionalism</p>
            </div>

            <div className="text-center p-6">
              <div className="mx-auto mb-4 p-3 rounded-full bg-primary/10 w-fit">
                <Zap className="h-8 w-8 text-primary" />
              </div>
              <h4 className="text-lg font-semibold text-foreground mb-2">Innovation Hub</h4>
              <p className="text-sm text-muted-foreground">Cutting-edge technology and forward-thinking approach</p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default SponsorsSection; 