import { Trophy, Mail, Phone, MapPin, Facebook, Twitter, Instagram, Youtube, Video } from "lucide-react";
import { Button } from "@/components/ui/button";
import { Separator } from "@/components/ui/separator";
import { Link } from "@inertiajs/react";

const Footer = () => {
  const currentYear = new Date().getFullYear();

  const footerLinks = {
    tournament: [
      { name: "About Tournament", to: "/about" },
      { name: "How to Register", to: "/how-to-register" },
      { name: "Rules & Regulations", to: "/rules" },
      { name: "Prize Structure", to: "/prizes" }
    ],
    services: [
      { name: "Team Registration", to: "/register" },
      // { name: "Player Registration", to: "/player-register" },
      { name: "Fixtures & Results", to: "/fixtures" },
      { name: "Certificates", to: "/certificates" }
    ],
    support: [
      // { name: "Help Center", to: "/help" },
      { name: "Contact Support", to: "/contact" },
      { name: "FAQ", to: "/faq" },
      // { name: "Technical Issues", to: "/tech-support" }
    ]
  };

  const socialLinks = [
    { icon: Facebook, href: "https://www.facebook.com/share/16vbkxF1vY/", label: "Facebook" },
    // { icon: Twitter, href: "https://x.com/milimusgerry", label: "Twitter" },
    { icon: Instagram, href: "https://www.instagram.com/the_milimus_tournament", label: "Instagram" },
    { icon: Youtube, href: "https://www.youtube.com/@TheMilimusGerryTournamentcup", label: "YouTube" },
    { icon: Video, href: "https://www.tiktok.com/@the.milimus.tourn?_t=ZM-8yIfsMBR37l&_r=1", label: "Tiktok" }
  ];

  return (
    <footer className="bg-[hsl(147_40%_20%)] text-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Main Footer Content */}
        <div className="py-16">
          <div className="grid lg:grid-cols-5 gap-8">
            {/* Brand Section */}
            <div className="lg:col-span-2">
              <div className="flex items-center justify-start space-x-3 mb-6">
                <img 
                  src="/images/mtc-logo.jpg" 
                  alt="Tournament Logo" 
                  className="h-20 object-contain"
                />
                <div>
                  <span className="font-poppins font-bold text-2xl">The Milimus Tournament</span>
                </div>
              </div>
              <p className="text-gray-300 mb-6 max-w-md">
              Nurturing and supporting local talent is our ultimate Goal in memory of The Late Ev. Gerishom Milimu
              </p>
              {/* Contact Info */}
              <div className="space-y-3">
                <div className="item-start flex justify-start space-x-3">
                  <Mail className="h-5 w-5 text-red-700" />
                  <span className="text-gray-300">themilimusgerrytournamentcup@gmail.com</span>
                </div>
                <div className="item-start flex justify-start space-x-3">
                  <Phone className="h-5 w-5 text-red-700" />
                  <span className="text-gray-300">0796 739699</span>
                </div>
                <div className="item-start flex justify-start space-x-3">
                  <MapPin className="h-5 w-5 text-red-700" />
                  <span className="text-gray-300">Ingolomosio, Shinyalu Constituency, Kakamega, Kenya</span>
                </div>
              </div>
              {/* Social Links */}
              <div className="mt-4">
                <h4 className="font-medium mb-3">Follow Us</h4>
                <div className="flex space-x-3">
                  {socialLinks.map((social) => (
                    <Button
                      key={social.label}
                      variant="outline"
                      size="sm"
                      className="border-gray-600 rounded-full"
                      asChild
                    >
                      <a href={social.href} aria-label={social.label}>
                        {social.icon === Video ? (
                          <svg
                          xmlns="http://www.w3.org/2000/svg"
                          viewBox="0 0 40 40"
                          fill="none"
                          className="w-5 h-5"
                        >
                          <g>
                            <path
                              d="M28.5 10.5c-1.1 0-2-.9-2-2V5.5h-3.5v18.5c0 2.8-2.2 5-5 5s-5-2.2-5-5 2.2-5 5-5c.3 0 .7 0 1 .1v-3.6c-.3 0-.7-.1-1-.1-4.7 0-8.5 3.8-8.5 8.5s3.8 8.5 8.5 8.5 8.5-3.8 8.5-8.5V16.5c1.5 1.1 3.3 1.8 5.3 1.8v-3.5c-1.7 0-3.3-.6-4.5-1.8z"
                              fill="#25F4EE"
                            />
                            <path
                              d="M29.5 13.5v3.5c2 0 3.8-.7 5.3-1.8v-3.6c-1.5 1.1-3.3 1.9-5.3 1.9z"
                              fill="#FE2C55"
                            />
                            <path
                              d="M26.5 5.5v3c0 1.1.9 2 2 2 .3 0 .7 0 1-.1v-4.9h-3z"
                              fill="#FE2C55"
                            />
                            <path
                              d="M26.5 5.5v18.5c0 2.8-2.2 5-5 5s-5-2.2-5-5c0-2.8 2.2-5 5-5 .3 0 .7 0 1 .1v-3.6c-.3 0-.7-.1-1-.1-4.7 0-8.5 3.8-8.5 8.5s3.8 8.5 8.5 8.5 8.5-3.8 8.5-8.5V16.5c1.5 1.1 3.3 1.8 5.3 1.8v-3.5c-1.7 0-3.3-.6-4.5-1.8z"
                              fill="#000"
                              fillOpacity=".8"
                            />
                          </g>
                        </svg>
                        ) : (
                          <social.icon className={`h-3 w-3 social-icon font-bold ${social.icon === Facebook ? 'text-blue-500' : social.icon === Twitter ? 'text-blue-500' : social.icon === Instagram ? 'text-red-500' : social.icon === Youtube ? 'text-red-500' : 'text-white'}`} />
                        )}
                      </a>
                    </Button>
                  ))}
                </div>
              </div>
            </div>
            {/* Links Sections */}
            <div>
              <h3 className="font-semibold text-lg mb-4 text-white">Tournament</h3>
              <ul className="space-y-2">
                {footerLinks.tournament.map((link) => (
                  <li key={link.name}>
                    <Link 
                      href={link.to} 
                      className="text-gray-300 hover:text-white transition-colors"
                    >
                      {link.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            <div>
              <h3 className="font-semibold text-lg mb-4 text-white">Services</h3>
              <ul className="space-y-2">
                {footerLinks.services.map((link) => (
                  <li key={link.name}>
                    <Link 
                      href={link.to} 
                      className="text-gray-300 hover:text-white transition-colors"
                    >
                      {link.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            <div>
              <h3 className="font-semibold text-lg mb-4 text-white">Support</h3>
              <ul className="space-y-2 mb-6">
                {footerLinks.support.map((link) => (
                  <li key={link.name}>
                    <Link 
                      href={link.to} 
                      className="text-gray-300 hover:text-white transition-colors"
                    >
                      {link.name}
                    </Link>
                  </li>
                ))}
              </ul>
              
            </div>
          </div>
        </div>
        <Separator className="bg-gray-700" />
        {/* Bottom Footer */}
        <div className="py-6">
          <div className="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
            <div className="text-gray-300 text-sm">
              © {currentYear} The Milimus Tournament Manager. All rights reserved.{/* Built with ❤️ by <a href="https://www.victor.co.ke" className="text-red-500 hover:text-white transition-colors">Victor</a> */}
            </div>
            <div className="flex space-x-6 text-sm">
              <Link href="/privacy" className="text-gray-300 hover:text-white transition-colors">
                Privacy Policy
              </Link>
              <Link href="/terms" className="text-gray-300 hover:text-white transition-colors">
                Terms of Service
              </Link>
              <Link href="/cookies" className="text-gray-300 hover:text-white transition-colors">
                Cookie Policy
              </Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;