import { Users, FileText, CreditCard, Calendar, Award, Shield, Download, Phone } from "lucide-react";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";

const FeaturesSection = () => {
  const features = [
    {
      icon: Users,
      title: "Team Registration",
      description: "Quick and easy team registration with manager details and player roster management",
      color: "text-primary"
    },
    {
      icon: FileText,
      title: "Document Upload",
      description: "Secure document submission for player verification and team certification",
      color: "text-secondary"
    },
    {
      icon: CreditCard,
      title: "Mpesa Integration",
      description: "Seamless payment processing with Mpesa for registration fees and tournament costs",
      color: "text-primary"
    },
    {
      icon: Calendar,
      title: "Fixture Management",
      description: "Real-time fixture updates, match scheduling, and automated notifications",
      color: "text-secondary"
    },
    {
      icon: Award,
      title: "Results & Rankings",
      description: "Live score updates, tournament standings, and championship tracking",
      color: "text-primary"
    },
    {
      icon: Shield,
      title: "Admin Dashboard",
      description: "Comprehensive admin panel for tournament management and player verification",
      color: "text-secondary"
    },
    {
      icon: Download,
      title: "Player E-Cards",
      description: "Downloadable digital player cards and participation certificates",
      color: "text-primary"
    },
    {
      icon: Phone,
      title: "24/7 Support",
      description: "Round-the-clock customer support for teams, players, and tournament organizers",
      color: "text-secondary"
    }
  ];

  return (
    <section id="features" className="py-20 bg-background">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Header */}
        <div className="text-center mb-16 animate-fade-in-up">
          <h2 className="font-poppins font-bold text-3xl md:text-4xl text-foreground mb-4">
            Everything You Need to <span className="text-primary">Manage</span> Your Tournament
          </h2>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
            From registration to celebration, our platform provides all the tools needed for a successful sports tournament experience.
          </p>
        </div>

        {/* Features Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-16">
          {features.map((feature, index) => (
            <Card 
              key={index} 
              className="sports-card border-none bg-white shadow-lg hover:shadow-xl transition-all duration-300"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              <CardHeader className="text-center pb-4">
                <div className={`${feature.color} bg-current/10 rounded-full p-4 w-16 h-16 mx-auto mb-4 flex items-center justify-center`}>
                  <feature.icon className={`h-8 w-8 ${feature.color}`} />
                </div>
                <CardTitle className="text-lg font-semibold">{feature.title}</CardTitle>
              </CardHeader>
              <CardContent className="text-center">
                <CardDescription className="text-muted-foreground">
                  {feature.description}
                </CardDescription>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* CTA Section */}
        <div className="text-center bg-gradient-to-r from-primary to-secondary rounded-3xl p-8 md:p-12 text-white">
          <h3 className="font-poppins font-bold text-2xl md:text-3xl mb-4">
            Ready to Start Your Tournament Journey?
          </h3>
          <p className="text-xl mb-8 opacity-90">
            Join thousands of teams already using our platform to manage their sports tournaments.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" variant="secondary" className="text-lg px-8 py-3 rounded-full">
              Register Your Team
            </Button>
            <Button size="lg" variant="outline" className="text-lg px-8 py-3 rounded-full border-white text-white hover:bg-white hover:text-primary">
              Learn More
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default FeaturesSection;