import { Trophy, Calendar, Users, ArrowRight } from "lucide-react";
import { Button } from "@/components/ui/button";

const CallToActionSection = () => {
  const benefits = [
    {
      icon: Trophy,
      title: "Championship Glory",
      description: "Compete for the prestigious Milimus Trophy"
    },
    {
      icon: Calendar,
      title: "Professional Schedule",
      description: "Well-organized matches over 3 weeks"
    },
    {
      icon: Users,
      title: "Top Teams",
      description: "Face the best teams from the region"
    }
  ];

  return (
    <section className="py-20 bg-gradient-to-br from-primary/90 to-secondary/90 relative overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-10">
        <div className="absolute top-0 left-0 w-72 h-72 bg-white rounded-full -translate-x-1/2 -translate-y-1/2"></div>
        <div className="absolute bottom-0 right-0 w-96 h-96 bg-white rounded-full translate-x-1/2 translate-y-1/2"></div>
      </div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center text-white">
          {/* Main CTA */}
          <div className="mb-16">
            <h2 className="text-4xl md:text-6xl font-bold mb-6">
              Ready to Make <span className="text-green-800">History</span>?
            </h2>
            <p className="text-xl md:text-2xl text-white/90 max-w-3xl mx-auto mb-8">
              Join The Milimus Tournament 2025 and compete against the best teams in the region. 
              Registration is now open for the most prestigious football competition.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center mb-12">
              <Button size="lg" className="bg-green-700 text-black hover:bg-green-300 text-lg text-white px-8 py-4 rounded-full font-semibold">
                Register Your Team
                <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
              {/* <Button size="lg" variant="outline" className="text-white border-white/30 hover:bg-white/10 text-lg px-8 py-4 rounded-full font-semibold">
                View Tournament Rules
              </Button> */}
            </div>

            {/* Tournament Info */}
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-4xl mx-auto">
              <div className="text-center">
                <div className="text-3xl font-bold text-green-700 mb-2">32</div>
                <div className="text-white/80">Teams</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-green-700 mb-2">Ksh. 70,000</div>
                <div className="text-white/80">Prize Pool</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-green-700 mb-2">3 Weeks</div>
                <div className="text-white/80">Duration</div>
              </div>
            </div>
          </div>

          {/* Benefits */}
          <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-8">
            <h3 className="text-2xl font-bold mb-8">Why Join The Milimus Tournament?</h3>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
              {benefits.map((benefit: any, index: number) => (
                <div key={index} className="text-center">
                  <div className="mx-auto mb-4 p-3 rounded-full bg-white/20 w-fit">
                    <benefit.icon className="h-8 w-8 text-green-700" />
                  </div>
                  <h4 className="text-lg font-semibold mb-2">{benefit.title}</h4>
                  <p className="text-white/80 text-sm">{benefit.description}</p>
                </div>
              ))}
            </div>
          </div>

          {/* Final CTA */}
          <div className="mt-12">
            <p className="text-lg text-white/90 mb-6">
              Don't miss your chance to be part of football history
            </p>
            <Button size="lg" className="bg-green-700 text-black hover:bg-green-300 text-white text-lg px-8 py-4 rounded-full font-semibold">
              Register Now - Limited Spots Available
              <ArrowRight className="ml-2 h-5 w-5" />
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CallToActionSection; 