
import { usePage } from '@inertiajs/react';

interface AppLogoProps {
  className?: string;
}

const AppLogo = ({ className = '' }: AppLogoProps) => {
  const page = usePage();
  const appSettings = (page.props as any).appSettings;
  
  const logoUrl = appSettings?.logo;
  const siteName = appSettings?.name || 'Tournament Manager';

  if (logoUrl) {
    return (
      <img 
        src={logoUrl} 
        alt={siteName}
        className={`h-40 w-auto ${className}`}
      />
    );
  }

  return (
    <div className={`font-bold text-xl text-primary ${className}`}>
      {siteName}
    </div>
  );
};

export default AppLogo;
