import React from 'react';
import { usePage } from '@inertiajs/react';
import ImpersonationBanner from '@/components/ImpersonationBanner';

interface PageWrapperProps {
  children: React.ReactNode;
  className?: string;
}

interface PageProps {
  auth: {
    user: any;
    impersonation?: {
      is_impersonating: boolean;
      impersonated_user: {
        id: number;
        name: string;
        email: string;
      };
      original_user: {
        id: number;
        name: string;
        email: string;
      };
    };
  };
}

const PageWrapper: React.FC<PageWrapperProps> = ({ children, className = "" }) => {
  const { auth } = usePage<PageProps>().props;
  const isImpersonating = auth.impersonation?.is_impersonating || false;

  return (
    <>
      {/* Impersonation Banner */}
      {isImpersonating && auth.impersonation && (
        <ImpersonationBanner
          impersonatedUser={auth.impersonation.impersonated_user}
          originalUser={auth.impersonation.original_user}
        />
      )}
      
      {/* Page Content */}
      <div className={`${isImpersonating ? 'pt-16' : ''} ${className}`}>
        {children}
      </div>
    </>
  );
};

export default PageWrapper;