import React, { useEffect, useState } from 'react';
import CertificatePreviewDialog from './CertificatePreviewDialog';
import { useCertificatePreview } from '@/hooks/useCertificatePreview';

interface CertificateData {
    player_name: string;
    team_name?: string;
    position?: string;
    jersey_number?: string;
    tournament_matches_played?: number;
    tournament_win_rate?: number;
    global_rating?: number;
    digital_id: string;
    issued_date: string;
    tournament_name: string;
    description?: string;
    verification_status?: string;
}

interface CertificateManagerProps {
    children?: React.ReactNode;
}

const CertificateManager: React.FC<CertificateManagerProps> = ({ children }) => {
    const {
        isOpen,
        certificateData,
        playerId,
        openPreview,
        closePreview,
    } = useCertificatePreview();

    useEffect(() => {
        const handleOpenCertificatePreview = (event: CustomEvent) => {
            const { playerId, certificateData } = event.detail;
            openPreview(playerId, certificateData);
        };

        // Listen for custom event to open certificate preview
        window.addEventListener('openCertificatePreview', handleOpenCertificatePreview as EventListener);

        return () => {
            window.removeEventListener('openCertificatePreview', handleOpenCertificatePreview as EventListener);
        };
    }, [openPreview]);

    return (
        <>
            {children}
            <CertificatePreviewDialog
                isOpen={isOpen}
                onClose={closePreview}
                certificateData={certificateData || {
                    player_name: '',
                    digital_id: '',
                    issued_date: '',
                    tournament_name: '',
                }}
                playerId={playerId || 0}
            />
        </>
    );
};

export default CertificateManager;
