// src/index.ts
import { router as Router } from "@inertiajs/core";

// src/createInertiaApp.ts
import { router as router2, setupProgress } from "@inertiajs/core";
import { createElement as createElement2 } from "react";

// src/App.ts
import { createHeadManager, router } from "@inertiajs/core";
import { createElement, useEffect, useMemo, useState } from "react";

// src/HeadContext.ts
import { createContext } from "react";
var headContext = createContext(void 0);
headContext.displayName = "InertiaHeadContext";
var HeadContext_default = headContext;

// src/PageContext.ts
import { createContext as createContext2 } from "react";
var pageContext = createContext2(void 0);
pageContext.displayName = "InertiaPageContext";
var PageContext_default = pageContext;

// src/App.ts
var currentIsInitialPage = true;
var routerIsInitialized = false;
var swapComponent = async () => {
  currentIsInitialPage = false;
};
function App({
  children,
  initialPage,
  initialComponent,
  resolveComponent,
  titleCallback,
  onHeadUpdate
}) {
  const [current, setCurrent] = useState({
    component: initialComponent || null,
    page: initialPage,
    key: null
  });
  const headManager = useMemo(() => {
    return createHeadManager(
      typeof window === "undefined",
      titleCallback || ((title) => title),
      onHeadUpdate || (() => {
      })
    );
  }, []);
  if (!routerIsInitialized) {
    router.init({
      initialPage,
      resolveComponent,
      swapComponent: async (args) => swapComponent(args)
    });
    routerIsInitialized = true;
  }
  useEffect(() => {
    swapComponent = async ({ component, page, preserveState }) => {
      if (currentIsInitialPage) {
        currentIsInitialPage = false;
        return;
      }
      setCurrent((current2) => ({
        component,
        page,
        key: preserveState ? current2.key : Date.now()
      }));
    };
    router.on("navigate", () => headManager.forceUpdate());
  }, []);
  if (!current.component) {
    return createElement(
      HeadContext_default.Provider,
      { value: headManager },
      createElement(PageContext_default.Provider, { value: current.page }, null)
    );
  }
  const renderChildren = children || (({ Component, props, key }) => {
    const child = createElement(Component, { key, ...props });
    if (typeof Component.layout === "function") {
      return Component.layout(child);
    }
    if (Array.isArray(Component.layout)) {
      return Component.layout.concat(child).reverse().reduce((children2, Layout) => createElement(Layout, { children: children2, ...props }));
    }
    return child;
  });
  return createElement(
    HeadContext_default.Provider,
    { value: headManager },
    createElement(
      PageContext_default.Provider,
      { value: current.page },
      renderChildren({
        Component: current.component,
        key: current.key,
        props: current.page.props
      })
    )
  );
}
App.displayName = "Inertia";

// src/createInertiaApp.ts
async function createInertiaApp({
  id = "app",
  resolve,
  setup,
  title,
  progress = {},
  page,
  render
}) {
  const isServer = typeof window === "undefined";
  const el = isServer ? null : document.getElementById(id);
  const initialPage = page || JSON.parse(el.dataset.page);
  const resolveComponent = (name) => Promise.resolve(resolve(name)).then((module) => module.default || module);
  let head = [];
  const reactApp = await Promise.all([
    resolveComponent(initialPage.component),
    router2.decryptHistory().catch(() => {
    })
  ]).then(([initialComponent]) => {
    return setup({
      // @ts-expect-error
      el,
      App,
      props: {
        initialPage,
        initialComponent,
        resolveComponent,
        titleCallback: title,
        onHeadUpdate: isServer ? (elements) => head = elements : null
      }
    });
  });
  if (!isServer && progress) {
    setupProgress(progress);
  }
  if (isServer) {
    const body = await render(
      createElement2(
        "div",
        {
          id,
          "data-page": JSON.stringify(initialPage)
        },
        // @ts-expect-error
        reactApp
      )
    );
    return { head, body };
  }
}

// src/Deferred.ts
import { useEffect as useEffect2, useMemo as useMemo2, useState as useState2 } from "react";

// src/usePage.ts
import { useContext } from "react";
function usePage() {
  const page = useContext(PageContext_default);
  if (!page) {
    throw new Error("usePage must be used within the Inertia component");
  }
  return page;
}

// src/Deferred.ts
var urlWithoutHash = (url) => {
  url = new URL(url.href);
  url.hash = "";
  return url;
};
var isSameUrlWithoutHash = (url1, url2) => {
  return urlWithoutHash(url1).href === urlWithoutHash(url2).href;
};
var Deferred = ({ children, data, fallback }) => {
  if (!data) {
    throw new Error("`<Deferred>` requires a `data` prop to be a string or array of strings");
  }
  const [loaded, setLoaded] = useState2(false);
  const pageProps = usePage().props;
  const keys = useMemo2(() => Array.isArray(data) ? data : [data], [data]);
  useEffect2(() => {
    const removeListener = router3.on("start", (e) => {
      const isPartialVisit = e.detail.visit.only.length > 0 || e.detail.visit.except.length > 0;
      const isReloadingKey = e.detail.visit.only.find((key) => keys.includes(key));
      if (isSameUrlWithoutHash(e.detail.visit.url, window.location) && (!isPartialVisit || isReloadingKey)) {
        setLoaded(false);
      }
    });
    return () => {
      removeListener();
    };
  }, []);
  useEffect2(() => {
    setLoaded(keys.every((key) => pageProps[key] !== void 0));
  }, [pageProps, keys]);
  return loaded ? children : fallback;
};
Deferred.displayName = "InertiaDeferred";
var Deferred_default = Deferred;

// src/Head.ts
import { escape } from "es-toolkit";
import React, { useContext as useContext2, useEffect as useEffect3, useMemo as useMemo3 } from "react";
var Head = function({ children, title }) {
  const headManager = useContext2(HeadContext_default);
  const provider = useMemo3(() => headManager.createProvider(), [headManager]);
  const isServer = typeof window === "undefined";
  useEffect3(() => {
    provider.reconnect();
    provider.update(renderNodes(children));
    return () => {
      provider.disconnect();
    };
  }, [provider, children, title]);
  function isUnaryTag(node) {
    return [
      "area",
      "base",
      "br",
      "col",
      "embed",
      "hr",
      "img",
      "input",
      "keygen",
      "link",
      "meta",
      "param",
      "source",
      "track",
      "wbr"
    ].indexOf(node.type) > -1;
  }
  function renderTagStart(node) {
    const attrs = Object.keys(node.props).reduce((carry, name) => {
      if (["head-key", "children", "dangerouslySetInnerHTML"].includes(name)) {
        return carry;
      }
      const value = String(node.props[name]);
      if (value === "") {
        return carry + ` ${name}`;
      } else {
        return carry + ` ${name}="${escape(value)}"`;
      }
    }, "");
    return `<${node.type}${attrs}>`;
  }
  function renderTagChildren(node) {
    return typeof node.props.children === "string" ? node.props.children : node.props.children.reduce((html, child) => html + renderTag(child), "");
  }
  function renderTag(node) {
    let html = renderTagStart(node);
    if (node.props.children) {
      html += renderTagChildren(node);
    }
    if (node.props.dangerouslySetInnerHTML) {
      html += node.props.dangerouslySetInnerHTML.__html;
    }
    if (!isUnaryTag(node)) {
      html += `</${node.type}>`;
    }
    return html;
  }
  function ensureNodeHasInertiaProp(node) {
    return React.cloneElement(node, {
      inertia: node.props["head-key"] !== void 0 ? node.props["head-key"] : ""
    });
  }
  function renderNode(node) {
    return renderTag(ensureNodeHasInertiaProp(node));
  }
  function renderNodes(nodes) {
    const computed = React.Children.toArray(nodes).filter((node) => node).map((node) => renderNode(node));
    if (title && !computed.find((tag) => tag.startsWith("<title"))) {
      computed.push(`<title inertia>${title}</title>`);
    }
    return computed;
  }
  if (isServer) {
    provider.update(renderNodes(children));
  }
  return null;
};
var Head_default = Head;

// src/Link.ts
import {
  mergeDataIntoQueryString,
  router as router4,
  shouldIntercept
} from "@inertiajs/core";
import { createElement as createElement3, forwardRef, useEffect as useEffect4, useMemo as useMemo4, useRef, useState as useState3 } from "react";
var noop = () => void 0;
var Link = forwardRef(
  ({
    children,
    as = "a",
    data = {},
    href,
    method = "get",
    preserveScroll = false,
    preserveState = null,
    replace = false,
    only = [],
    except = [],
    headers = {},
    queryStringArrayFormat = "brackets",
    async = false,
    onClick = noop,
    onCancelToken = noop,
    onBefore = noop,
    onStart = noop,
    onProgress = noop,
    onFinish = noop,
    onCancel = noop,
    onSuccess = noop,
    onError = noop,
    prefetch = false,
    cacheFor = 0,
    ...props
  }, ref) => {
    const [inFlightCount, setInFlightCount] = useState3(0);
    const hoverTimeout = useRef(null);
    const _method = useMemo4(() => {
      return typeof href === "object" ? href.method : method.toLowerCase();
    }, [href, method]);
    const _as = useMemo4(() => {
      as = as.toLowerCase();
      return _method !== "get" ? "button" : as;
    }, [as, _method]);
    const mergeDataArray = useMemo4(
      () => mergeDataIntoQueryString(
        _method,
        typeof href === "object" ? href.url : href || "",
        data,
        queryStringArrayFormat
      ),
      [href, _method, data, queryStringArrayFormat]
    );
    const url = useMemo4(() => mergeDataArray[0], [mergeDataArray]);
    const _data = useMemo4(() => mergeDataArray[1], [mergeDataArray]);
    const baseParams = useMemo4(
      () => ({
        data: _data,
        method: _method,
        preserveScroll,
        preserveState: preserveState ?? _method !== "get",
        replace,
        only,
        except,
        headers,
        async
      }),
      [_data, _method, preserveScroll, preserveState, replace, only, except, headers, async]
    );
    const visitParams = useMemo4(
      () => ({
        ...baseParams,
        onCancelToken,
        onBefore,
        onStart(event) {
          setInFlightCount((count) => count + 1);
          onStart(event);
        },
        onProgress,
        onFinish(event) {
          setInFlightCount((count) => count - 1);
          onFinish(event);
        },
        onCancel,
        onSuccess,
        onError
      }),
      [baseParams, onCancelToken, onBefore, onStart, onProgress, onFinish, onCancel, onSuccess, onError]
    );
    const doPrefetch = () => {
      router4.prefetch(url, baseParams, { cacheFor: cacheForValue });
    };
    const prefetchModes = useMemo4(
      () => {
        if (prefetch === true) {
          return ["hover"];
        }
        if (prefetch === false) {
          return [];
        }
        if (Array.isArray(prefetch)) {
          return prefetch;
        }
        return [prefetch];
      },
      Array.isArray(prefetch) ? prefetch : [prefetch]
    );
    const cacheForValue = useMemo4(() => {
      if (cacheFor !== 0) {
        return cacheFor;
      }
      if (prefetchModes.length === 1 && prefetchModes[0] === "click") {
        return 0;
      }
      return 3e4;
    }, [cacheFor, prefetchModes]);
    useEffect4(() => {
      return () => {
        clearTimeout(hoverTimeout.current);
      };
    }, []);
    useEffect4(() => {
      if (prefetchModes.includes("mount")) {
        setTimeout(() => doPrefetch());
      }
    }, prefetchModes);
    const regularEvents = {
      onClick: (event) => {
        onClick(event);
        if (shouldIntercept(event)) {
          event.preventDefault();
          router4.visit(url, visitParams);
        }
      }
    };
    const prefetchHoverEvents = {
      onMouseEnter: () => {
        hoverTimeout.current = window.setTimeout(() => {
          doPrefetch();
        }, 75);
      },
      onMouseLeave: () => {
        clearTimeout(hoverTimeout.current);
      },
      onClick: regularEvents.onClick
    };
    const prefetchClickEvents = {
      onMouseDown: (event) => {
        if (shouldIntercept(event)) {
          event.preventDefault();
          doPrefetch();
        }
      },
      onMouseUp: (event) => {
        event.preventDefault();
        router4.visit(url, visitParams);
      },
      onClick: (event) => {
        onClick(event);
        if (shouldIntercept(event)) {
          event.preventDefault();
        }
      }
    };
    const elProps = useMemo4(
      () => ({
        a: { href: url },
        button: { type: "button" }
      }),
      [url]
    );
    return createElement3(
      _as,
      {
        ...props,
        ...elProps[_as] || {},
        ref,
        ...(() => {
          if (prefetchModes.includes("hover")) {
            return prefetchHoverEvents;
          }
          if (prefetchModes.includes("click")) {
            return prefetchClickEvents;
          }
          return regularEvents;
        })(),
        "data-loading": inFlightCount > 0 ? "" : void 0
      },
      children
    );
  }
);
Link.displayName = "InertiaLink";
var Link_default = Link;

// src/useForm.ts
import {
  router as router6
} from "@inertiajs/core";
import { cloneDeep, isEqual } from "es-toolkit";
import { get, has, set } from "es-toolkit/compat";
import { useCallback, useEffect as useEffect6, useLayoutEffect, useMemo as useMemo5, useRef as useRef2, useState as useState5 } from "react";

// src/useRemember.ts
import { router as router5 } from "@inertiajs/core";
import { useEffect as useEffect5, useState as useState4 } from "react";
function useRemember(initialState, key) {
  const [state, setState] = useState4(() => {
    const restored = router5.restore(key);
    return restored !== void 0 ? restored : initialState;
  });
  useEffect5(() => {
    router5.remember(state, key);
  }, [state, key]);
  return [state, setState];
}

// src/useForm.ts
function useForm(rememberKeyOrInitialValues, maybeInitialValues) {
  const isMounted = useRef2(null);
  const rememberKey = typeof rememberKeyOrInitialValues === "string" ? rememberKeyOrInitialValues : null;
  const [defaults, setDefaults] = useState5(
    (typeof rememberKeyOrInitialValues === "string" ? maybeInitialValues : rememberKeyOrInitialValues) || {}
  );
  const cancelToken = useRef2(null);
  const recentlySuccessfulTimeoutId = useRef2(null);
  const [data, setData] = rememberKey ? useRemember(defaults, `${rememberKey}:data`) : useState5(defaults);
  const [errors, setErrors] = rememberKey ? useRemember({}, `${rememberKey}:errors`) : useState5({});
  const [hasErrors, setHasErrors] = useState5(false);
  const [processing, setProcessing] = useState5(false);
  const [progress, setProgress] = useState5(null);
  const [wasSuccessful, setWasSuccessful] = useState5(false);
  const [recentlySuccessful, setRecentlySuccessful] = useState5(false);
  const transform = useRef2((data2) => data2);
  const isDirty = useMemo5(() => !isEqual(data, defaults), [data, defaults]);
  useEffect6(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  const submit = useCallback(
    (...args) => {
      const objectPassed = typeof args[0] === "object";
      const method = objectPassed ? args[0].method : args[0];
      const url = objectPassed ? args[0].url : args[1];
      const options = (objectPassed ? args[1] : args[2]) ?? {};
      const _options = {
        ...options,
        onCancelToken: (token) => {
          cancelToken.current = token;
          if (options.onCancelToken) {
            return options.onCancelToken(token);
          }
        },
        onBefore: (visit) => {
          setWasSuccessful(false);
          setRecentlySuccessful(false);
          clearTimeout(recentlySuccessfulTimeoutId.current);
          if (options.onBefore) {
            return options.onBefore(visit);
          }
        },
        onStart: (visit) => {
          setProcessing(true);
          if (options.onStart) {
            return options.onStart(visit);
          }
        },
        onProgress: (event) => {
          setProgress(event);
          if (options.onProgress) {
            return options.onProgress(event);
          }
        },
        onSuccess: (page) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
            setErrors({});
            setHasErrors(false);
            setWasSuccessful(true);
            setRecentlySuccessful(true);
            setDefaults(cloneDeep(data));
            recentlySuccessfulTimeoutId.current = setTimeout(() => {
              if (isMounted.current) {
                setRecentlySuccessful(false);
              }
            }, 2e3);
          }
          if (options.onSuccess) {
            return options.onSuccess(page);
          }
        },
        onError: (errors2) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
            setErrors(errors2);
            setHasErrors(true);
          }
          if (options.onError) {
            return options.onError(errors2);
          }
        },
        onCancel: () => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
          }
          if (options.onCancel) {
            return options.onCancel();
          }
        },
        onFinish: (visit) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
          }
          cancelToken.current = null;
          if (options.onFinish) {
            return options.onFinish(visit);
          }
        }
      };
      if (method === "delete") {
        router6.delete(url, { ..._options, data: transform.current(data) });
      } else {
        router6[method](url, transform.current(data), _options);
      }
    },
    [data, setErrors, transform]
  );
  const setDataFunction = useCallback(
    (keyOrData, maybeValue) => {
      if (typeof keyOrData === "string") {
        setData((data2) => set(cloneDeep(data2), keyOrData, maybeValue));
      } else if (typeof keyOrData === "function") {
        setData((data2) => keyOrData(data2));
      } else {
        setData(keyOrData);
      }
    },
    [setData]
  );
  const [dataAsDefaults, setDataAsDefaults] = useState5(false);
  const setDefaultsFunction = useCallback(
    (fieldOrFields, maybeValue) => {
      if (typeof fieldOrFields === "undefined") {
        setDefaults(data);
        setDataAsDefaults(true);
      } else {
        setDefaults((defaults2) => {
          return typeof fieldOrFields === "string" ? set(cloneDeep(defaults2), fieldOrFields, maybeValue) : Object.assign(cloneDeep(defaults2), fieldOrFields);
        });
      }
    },
    [data, setDefaults]
  );
  useLayoutEffect(() => {
    if (!dataAsDefaults) {
      return;
    }
    if (isDirty) {
      setDefaults(data);
    }
    setDataAsDefaults(false);
  }, [dataAsDefaults]);
  const reset = useCallback(
    (...fields) => {
      if (fields.length === 0) {
        setData(defaults);
      } else {
        setData(
          (data2) => fields.filter((key) => has(defaults, key)).reduce(
            (carry, key) => {
              return set(carry, key, get(defaults, key));
            },
            { ...data2 }
          )
        );
      }
    },
    [setData, defaults]
  );
  const setError = useCallback(
    (fieldOrFields, maybeValue) => {
      setErrors((errors2) => {
        const newErrors = {
          ...errors2,
          ...typeof fieldOrFields === "string" ? { [fieldOrFields]: maybeValue } : fieldOrFields
        };
        setHasErrors(Object.keys(newErrors).length > 0);
        return newErrors;
      });
    },
    [setErrors, setHasErrors]
  );
  const clearErrors = useCallback(
    (...fields) => {
      setErrors((errors2) => {
        const newErrors = Object.keys(errors2).reduce(
          (carry, field) => ({
            ...carry,
            ...fields.length > 0 && !fields.includes(field) ? { [field]: errors2[field] } : {}
          }),
          {}
        );
        setHasErrors(Object.keys(newErrors).length > 0);
        return newErrors;
      });
    },
    [setErrors, setHasErrors]
  );
  const resetAndClearErrors = useCallback(
    (...fields) => {
      reset(...fields);
      clearErrors(...fields);
    },
    [reset, clearErrors]
  );
  const createSubmitMethod = (method) => (url, options) => {
    submit(method, url, options);
  };
  const getMethod = useCallback(createSubmitMethod("get"), [submit]);
  const post = useCallback(createSubmitMethod("post"), [submit]);
  const put = useCallback(createSubmitMethod("put"), [submit]);
  const patch = useCallback(createSubmitMethod("patch"), [submit]);
  const deleteMethod = useCallback(createSubmitMethod("delete"), [submit]);
  const cancel = useCallback(() => {
    if (cancelToken.current) {
      cancelToken.current.cancel();
    }
  }, []);
  const transformFunction = useCallback((callback) => {
    transform.current = callback;
  }, []);
  return {
    data,
    setData: setDataFunction,
    isDirty,
    errors,
    hasErrors,
    processing,
    progress,
    wasSuccessful,
    recentlySuccessful,
    transform: transformFunction,
    setDefaults: setDefaultsFunction,
    reset,
    setError,
    clearErrors,
    resetAndClearErrors,
    submit,
    get: getMethod,
    post,
    put,
    patch,
    delete: deleteMethod,
    cancel
  };
}

// src/usePoll.ts
import { router as router7 } from "@inertiajs/core";
import { useEffect as useEffect7, useRef as useRef3 } from "react";
function usePoll(interval, requestOptions = {}, options = {
  keepAlive: false,
  autoStart: true
}) {
  const pollRef = useRef3(
    router7.poll(interval, requestOptions, {
      ...options,
      autoStart: false
    })
  );
  useEffect7(() => {
    if (options.autoStart ?? true) {
      pollRef.current.start();
    }
    return () => pollRef.current.stop();
  }, []);
  return {
    stop: pollRef.current.stop,
    start: pollRef.current.start
  };
}

// src/usePrefetch.ts
import { router as router8 } from "@inertiajs/core";
import { useEffect as useEffect8, useState as useState6 } from "react";
function usePrefetch(options = {}) {
  const cached = typeof window === "undefined" ? null : router8.getCached(window.location.pathname, options);
  const inFlight = typeof window === "undefined" ? null : router8.getPrefetching(window.location.pathname, options);
  const [lastUpdatedAt, setLastUpdatedAt] = useState6(cached?.staleTimestamp || null);
  const [isPrefetching, setIsPrefetching] = useState6(inFlight !== null);
  const [isPrefetched, setIsPrefetched] = useState6(cached !== null);
  useEffect8(() => {
    const onPrefetchingListener = router8.on("prefetching", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        setIsPrefetching(true);
      }
    });
    const onPrefetchedListener = router8.on("prefetched", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        setIsPrefetching(false);
        setIsPrefetched(true);
        setLastUpdatedAt(e.detail.fetchedAt);
      }
    });
    return () => {
      onPrefetchedListener();
      onPrefetchingListener();
    };
  }, []);
  return {
    lastUpdatedAt,
    isPrefetching,
    isPrefetched,
    flush: () => router8.flush(window.location.pathname, options)
  };
}

// src/WhenVisible.ts
import { router as router9 } from "@inertiajs/core";
import { createElement as createElement4, useCallback as useCallback2, useEffect as useEffect9, useRef as useRef4, useState as useState7 } from "react";
var WhenVisible = ({ children, data, params, buffer, as, always, fallback }) => {
  always = always ?? false;
  as = as ?? "div";
  fallback = fallback ?? null;
  const [loaded, setLoaded] = useState7(false);
  const hasFetched = useRef4(false);
  const fetching = useRef4(false);
  const ref = useRef4(null);
  const getReloadParams = useCallback2(() => {
    if (data) {
      return {
        only: Array.isArray(data) ? data : [data]
      };
    }
    if (!params) {
      throw new Error("You must provide either a `data` or `params` prop.");
    }
    return params;
  }, [params, data]);
  useEffect9(() => {
    if (!ref.current) {
      return;
    }
    const observer = new IntersectionObserver(
      (entries) => {
        if (!entries[0].isIntersecting) {
          return;
        }
        if (!always && hasFetched.current) {
          observer.disconnect();
        }
        if (fetching.current) {
          return;
        }
        hasFetched.current = true;
        fetching.current = true;
        const reloadParams = getReloadParams();
        router9.reload({
          ...reloadParams,
          onStart: (e) => {
            fetching.current = true;
            reloadParams.onStart?.(e);
          },
          onFinish: (e) => {
            setLoaded(true);
            fetching.current = false;
            reloadParams.onFinish?.(e);
            if (!always) {
              observer.disconnect();
            }
          }
        });
      },
      {
        rootMargin: `${buffer || 0}px`
      }
    );
    observer.observe(ref.current);
    return () => {
      observer.disconnect();
    };
  }, [ref, getReloadParams, buffer]);
  if (always || !loaded) {
    return createElement4(
      as,
      {
        props: null,
        ref
      },
      loaded ? children : fallback
    );
  }
  return loaded ? children : null;
};
WhenVisible.displayName = "InertiaWhenVisible";
var WhenVisible_default = WhenVisible;

// src/index.ts
var router3 = Router;
export {
  Deferred_default as Deferred,
  Head_default as Head,
  Link_default as Link,
  WhenVisible_default as WhenVisible,
  createInertiaApp,
  router3 as router,
  useForm,
  usePage,
  usePoll,
  usePrefetch,
  useRemember
};
//# sourceMappingURL=index.esm.js.map
