# User Guide

## 17.1 Getting Started

### System Overview
The Tournament Management System is a comprehensive platform for managing football tournaments. It provides tools for tournament organizers, team managers, players, and officials to manage all aspects of tournament participation.

### User Roles
- **Super Admin**: Full system access and management
- **Admin**: Tournament and user management
- **Tournament Organizer**: Create and manage tournaments
- **Team Manager**: Manage team and player registrations
- **Player**: Manage personal profile and view tournament information
- **Referee**: Manage match assignments and results
- **Official**: Tournament operations and support

### First Time Setup
1. **Account Creation**: Register with email and password
2. **Profile Completion**: Complete your profile information
3. **Role Assignment**: Get assigned appropriate role by admin
4. **Tournament Access**: Access tournaments based on your role
5. **Team Registration**: Register team (if applicable)

## 17.2 Admin Guide

### Dashboard Overview
The admin dashboard provides comprehensive system management capabilities:

- **System Statistics**: User counts, tournament statistics, payment summaries
- **User Management**: User accounts, roles, and permissions
- **Tournament Management**: Create, edit, and manage tournaments
- **Team Management**: Team registrations and approvals
- **Payment Management**: Payment tracking and processing
- **System Settings**: Configuration and maintenance

### User Management
1. **View Users**: Access user list with filtering and search
2. **Create Users**: Add new users with appropriate roles
3. **Edit Users**: Modify user information and roles
4. **User Permissions**: Assign and manage user permissions
5. **User Status**: Activate/deactivate user accounts

### Tournament Management
1. **Create Tournament**: Set up new tournaments with all details
2. **Tournament Settings**: Configure tournament parameters
3. **Participant Management**: Manage team registrations
4. **Approval Workflow**: Review and approve team registrations
5. **Match Management**: Oversee match scheduling and results
6. **Tournament Completion**: Finalize tournaments and generate reports

### System Configuration
1. **Email Settings**: Configure email services
2. **Payment Settings**: Set up payment processing
3. **Tournament Settings**: Configure global tournament parameters
4. **System Settings**: General system configuration
5. **Security Settings**: Authentication and authorization
6. **Backup Management**: System backup and recovery

### Tournament Settings Configuration

Navigate to **Admin → Tournament Settings** to configure global tournament parameters.

#### Global Location Settings
- **Available Countries**: System-wide countries for team registration (default: Kenya)
- **Available Counties**: Global county list used when category restrictions are disabled

#### Category Location Settings
Each category (Men, Women, Youth Male, Youth Female, Children) can be configured independently:

**Restriction Toggle:**
- **ON**: Teams must select from specific allowed locations (dropdown)
- **OFF**: Teams can enter any location (free text input)

**How to Configure:**
1. Navigate to Category Location Settings section
2. For each category, toggle "Restrict Locations" switch
3. When enabled, add specific locations using the tags input
4. When disabled, the location input is disabled (teams can enter any location)
5. Click "Save Settings" - changes take effect immediately (auto-cache clear)

**Example Use Cases:**
- Restrict Men's category to major cities only
- Allow Women's teams from any location
- Limit Youth categories to specific training centers

## 17.3 Tournament Organizer Guide

### Creating Tournaments
1. **Basic Information**: Enter tournament name, description, dates
2. **Tournament Type**: Select tournament format (knockout, round-robin, etc.)
3. **Tournament Settings**: Use switch toggles for:
   - Auto-accept Registrations
   - Allow Spectators
   - Require Approval
   - Featured Tournament
4. **Registration Settings**: Set registration dates and participant limits
5. **Category Configuration**: 
   - Toggle "Team Categories" to enable/disable category system
   - Use switches to enable/disable individual categories (Men, Women, Youth, Children)
   - Set category-specific registration fees
   - Fee inputs only shown for enabled categories
6. **Entry Fees**: Configure default entry fee and payment methods
7. **Streaming**: Toggle streaming and add stream URLs
8. **Rules & Regulations**: Add tournament rules and requirements
9. **Publishing**: Publish tournament for team registration

### Managing Participants
1. **Team Registration**: Review team registration requests
2. **Approval Process**: Approve or reject team registrations
3. **Payment Verification**: Confirm payment completion
4. **Participant Communication**: Send updates and notifications
5. **Document Verification**: Verify team and player documents

### Tournament Execution
1. **Bracket Generation**: Create tournament brackets
2. **Match Scheduling**: Schedule matches and assign venues
3. **Referee Assignment**: Assign referees to matches
4. **Result Entry**: Enter match results and scores
5. **Tournament Progression**: Manage tournament advancement
6. **Final Results**: Complete tournament and generate certificates

## 17.4 Team Manager Guide

### Team Registration

**New Multi-Step Registration Flow:**

1. **Select Tournament**: Choose which tournament to register for
2. **Select Category**: 
   - View available categories (only enabled categories shown)
   - See age requirements, gender requirements, and entry fee for each
   - Select ONE category that matches your team
3. **Enter Team Details**: 
   - Team name, email, phone
   - Location entry (dynamic based on category):
     - **Restricted category**: Select location from dropdown
     - **Unrestricted category**: Enter any location via text input
   - Founded year
4. **Team Manager Account**: Create manager account credentials
5. **Add Players**: Register 11-23 players with:
   - Name, email, phone, position
   - ID number/Birth certificate number
   - Date of birth and gender (validated against category)
   - Location (same restriction rules as team)
6. **Add Officials**: Register team officials (coaches, managers, physio, etc.)
7. **Review & Submit**: Review all information and accept terms
8. **Payment Processing**: Complete category-specific entry fee payment
9. **Approval Waiting**: Wait for admin approval (if required)

### Team Management
1. **Player Management**: Add, edit, or remove players
2. **Formation Setup**: Create team formations and tactics
3. **Player Statistics**: Track player performance and statistics
4. **Team Communication**: Communicate with team members
5. **Tournament Participation**: Manage tournament participation

### Match Management
1. **Match Schedule**: View upcoming matches
2. **Match Preparation**: Prepare team for matches
3. **Result Submission**: Submit match results (if applicable)
4. **Performance Tracking**: Monitor team performance
5. **Tournament Progress**: Track tournament advancement

## 17.5 Player Guide

### Profile Management
1. **Personal Information**: Update personal details
2. **Contact Information**: Manage contact details
3. **Physical Attributes**: Update height, weight, position
4. **Document Upload**: Upload ID documents and photos
5. **Emergency Contact**: Set emergency contact information
6. **Medical Information**: Add medical conditions and allergies

### Tournament Participation
1. **Tournament Viewing**: View available tournaments
2. **Team Registration**: Join team for tournament
3. **Match Information**: View match schedules and results
4. **Performance Tracking**: Monitor personal statistics
5. **Certificate Access**: Download participation certificates

### Player Features
1. **Digital ID**: Access digital player ID
2. **Statistics**: View personal performance statistics
3. **Achievements**: Track achievements and awards
4. **Tournament History**: View participation history
5. **Team Communication**: Communicate with team members

## 17.6 FAQ

### General Questions

**Q: How do I register for a tournament?**
A: First, create an account and complete your profile. Then, either join an existing team or create a new team and register for the tournament.

**Q: What documents do I need to upload?**
A: You need to upload a valid ID document (front and back), a profile photo, and any other documents required by the tournament.

**Q: How do I pay the entry fee?**
A: The system supports M-Pesa payments. You'll receive an STK Push notification on your phone to complete the payment.

**Q: How long does the approval process take?**
A: The approval process typically takes 24-48 hours, depending on the tournament requirements and admin availability.

### Technical Questions

**Q: I can't access my account. What should I do?**
A: Try resetting your password using the "Forgot Password" link on the login page. If the problem persists, contact support.

**Q: The payment failed. What should I do?**
A: Check your M-Pesa balance and try again. If the problem persists, contact support with your payment reference number.

**Q: I can't upload documents. What's wrong?**
A: Ensure your documents are in supported formats (JPG, PNG, PDF) and under the size limit (5MB). Check your internet connection.

**Q: How do I update my team information?**
A: Go to your team dashboard and click "Edit Team" to update team information. Changes may require admin approval.

### Tournament Questions

**Q: How do I create a tournament?**
A: Only users with organizer or admin roles can create tournaments. Contact an admin to get the appropriate role assigned.

**Q: Can I change my team after registration?**
A: Team changes after registration are generally not allowed. Contact the tournament organizer for special circumstances.

**Q: How do I view match results?**
A: Match results are available on the tournament page and your team dashboard. Results are updated in real-time.

**Q: When will I receive my certificate?**
A: Certificates are generated automatically after tournament completion. You'll receive an email notification when they're ready.

### Support Questions

**Q: How do I contact support?**
A: Use the contact form on the website or email support directly. Include your user ID and a detailed description of your issue.

**Q: Can I get a refund if I withdraw from a tournament?**
A: Refund policies vary by tournament. Check the tournament rules or contact the organizer for specific refund policies.

**Q: How do I report a technical issue?**
A: Use the technical support form or email support with detailed information about the issue, including screenshots if possible.

**Q: Is my personal information secure?**
A: Yes, the system uses industry-standard security measures to protect your personal information. All data is encrypted and stored securely.

---

## Getting Help

### Support Channels
- **Email Support**: support@tournament-system.com
- **Technical Support**: tech@tournament-system.com
- **Phone Support**: +254 700 000 000
- **Live Chat**: Available on the website
- **Help Center**: Comprehensive help articles and guides

### Documentation
- **User Manual**: Complete user guide
- **Video Tutorials**: Step-by-step video guides
- **FAQ Section**: Frequently asked questions
- **System Updates**: Latest feature announcements
- **Best Practices**: Tips for optimal system usage

### Community
- **User Forum**: Connect with other users
- **Feature Requests**: Suggest new features
- **Bug Reports**: Report system issues
- **User Feedback**: Share your experience
- **Success Stories**: Share your achievements

---

## Next Steps

- [Developer Guide](18_Developer_Guide.md) - Development and customization
- [API Reference](19_API_Reference.md) - Complete API documentation
- [System Architecture](03_System_Architecture.md) - Technical architecture
- [Installation & Setup](02_Installation_Setup.md) - System setup
