# Installation & Setup

## 2.1 Prerequisites

### System Requirements
- **PHP**: 8.2 or higher
- **Node.js**: 18.0 or higher
- **Composer**: 2.0 or higher
- **Database**: MySQL 8.0+ or SQLite 3
- **Web Server**: Apache 2.4+ or Nginx 1.18+
- **Memory**: Minimum 2GB RAM
- **Storage**: Minimum 10GB free space

### Development Tools
- **Git**: Version control
- **Code Editor**: VS Code, PhpStorm, or similar
- **Terminal**: Command line access
- **Browser**: Modern browser with developer tools

### PHP Extensions
```bash
# Required PHP extensions
php-mbstring
php-xml
php-curl
php-zip
php-gd
php-mysql
php-sqlite3
php-bcmath
php-intl
php-fileinfo
```

### Node.js Packages
```bash
# Global packages (optional)
npm install -g @vitejs/cli
npm install -g typescript
```

## 2.2 Environment Setup

### 1. Clone Repository
```bash
git clone <repository-url>
cd the-milimus-tournament
```

### 2. Install PHP Dependencies
```bash
composer install
```

### 3. Install Node.js Dependencies
```bash
npm install
```

### 4. Environment Configuration
```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate
```

### 5. Database Setup
```bash
# Create database (MySQL)
mysql -u root -p
CREATE DATABASE tournament_management;
exit

# Or use SQLite (default)
touch database/database.sqlite
```

## 2.3 Database Configuration

### MySQL Configuration
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=tournament_management
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

### SQLite Configuration (Development)
```env
DB_CONNECTION=sqlite
DB_DATABASE=/absolute/path/to/database.sqlite
```

### Run Migrations
```bash
# Run database migrations
php artisan migrate

# Run seeders (optional)
php artisan db:seed
```

## 2.4 Application Installation

### 1. Build Frontend Assets
```bash
# Development build
npm run dev

# Production build
npm run build
```

### 2. Set File Permissions
```bash
# Set storage permissions
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Set ownership (if needed)
chown -R www-data:www-data storage
chown -R www-data:www-data bootstrap/cache
```

### 3. Create Storage Links
```bash
# Create symbolic link for storage
php artisan storage:link
```

### 4. Clear Application Cache
```bash
# Clear all caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

## 2.5 Configuration

### Environment Variables
```env
# Application
APP_NAME="Tournament Management System"
APP_ENV=local
APP_KEY=base64:your-generated-key
APP_DEBUG=true
APP_URL=http://localhost

# Database
DB_CONNECTION=sqlite
DB_DATABASE=/path/to/database.sqlite

# Mail Configuration
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=your-email@gmail.com
MAIL_FROM_NAME="Tournament System"

# M-Pesa Configuration
MPESA_CONSUMER_KEY=your-consumer-key
MPESA_CONSUMER_SECRET=your-consumer-secret
MPESA_BASE_URL=https://sandbox.safaricom.co.ke
MPESA_PASSKEY=your-passkey
MPESA_SHORTCODE=your-shortcode
MPESA_CALLBACK_URL=http://localhost/api/callback

# Queue Configuration
QUEUE_CONNECTION=database
```

### Application Configuration
```php
// config/app.php
'name' => env('APP_NAME', 'Tournament Management System'),
'env' => env('APP_ENV', 'production'),
'debug' => env('APP_DEBUG', false),
'url' => env('APP_URL', 'http://localhost'),
```

### Database Configuration
```php
// config/database.php
'default' => env('DB_CONNECTION', 'sqlite'),
'connections' => [
    'sqlite' => [
        'driver' => 'sqlite',
        'database' => env('DB_DATABASE', database_path('database.sqlite')),
        'prefix' => '',
    ],
    'mysql' => [
        'driver' => 'mysql',
        'host' => env('DB_HOST', '127.0.0.1'),
        'port' => env('DB_PORT', '3306'),
        'database' => env('DB_DATABASE', 'tournament_management'),
        'username' => env('DB_USERNAME', 'root'),
        'password' => env('DB_PASSWORD', ''),
    ],
],
```

## 2.6 Testing

### Run Tests
```bash
# Run all tests
php artisan test

# Run specific test suite
php artisan test --testsuite=Feature
php artisan test --testsuite=Unit

# Run with coverage
php artisan test --coverage
```

### Test Database
```bash
# Create test database
php artisan migrate --env=testing

# Run tests with database
php artisan test --database=sqlite
```

### Frontend Testing
```bash
# Run frontend tests
npm run test

# Run with coverage
npm run test:coverage
```

### Manual Testing
1. **Access Application**: Navigate to `http://localhost`
2. **User Registration**: Create test user accounts
3. **Tournament Creation**: Create test tournament
4. **Team Registration**: Register test team
5. **Payment Testing**: Test payment flow (sandbox)
6. **Certificate Generation**: Test certificate creation

---

## Troubleshooting

### Common Issues

#### 1. Permission Errors
```bash
# Fix storage permissions
sudo chown -R www-data:www-data storage
sudo chmod -R 775 storage
```

#### 2. Database Connection Issues
```bash
# Check database connection
php artisan tinker
DB::connection()->getPdo();
```

#### 3. Frontend Build Issues
```bash
# Clear node modules and reinstall
rm -rf node_modules package-lock.json
npm install
npm run build
```

#### 4. Cache Issues
```bash
# Clear all caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

### Log Files
- **Application Logs**: `storage/logs/laravel.log`
- **Web Server Logs**: `/var/log/apache2/error.log` or `/var/log/nginx/error.log`
- **PHP Logs**: `/var/log/php/error.log`

### Performance Optimization
```bash
# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan optimize
```

---

## Next Steps

- [System Architecture](03_System_Architecture.md) - Understand system architecture
- [Configuration](13_Configuration.md) - Detailed configuration options
- [Deployment](14_Deployment.md) - Production deployment guide
- [User Guide](17_User_Guide.md) - Learn how to use the system
