<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Frontend\VlogVideo;

class VlogVideoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $videos = [
            [
                'title' => 'Milimu Cup 2024 Opening Ceremony',
                'description' => 'Highlights from the spectacular opening ceremony of Milimu Cup 2024',
                'platform' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
                'thumbnail_url' => '/images/gallery-1.JPG',
                'duration' => 180, // 3 minutes
                'views' => 15000,
                'likes' => 450,
                'category' => 'matches',
                'tags' => ['opening', 'ceremony', '2024'],
                'featured' => true,
                'status' => 'published',
                'published_at' => now()->subDays(5),
                'sort_order' => 1,
            ],
            [
                'title' => 'Behind the Scenes: Team Training',
                'description' => 'Exclusive look at team training sessions and preparation',
                'platform' => 'instagram',
                'video_url' => 'https://www.instagram.com/p/example123/',
                'thumbnail_url' => '/images/gallery-2.JPG',
                'duration' => 120, // 2 minutes
                'views' => 8500,
                'likes' => 320,
                'category' => 'behind-scenes',
                'tags' => ['training', 'behind-scenes', 'preparation'],
                'featured' => false,
                'status' => 'published',
                'published_at' => now()->subDays(3),
                'sort_order' => 2,
            ],
            [
                'title' => 'Player Interview: John Doe',
                'description' => 'Interview with star player John Doe about his journey and goals',
                'platform' => 'facebook',
                'video_url' => 'https://www.facebook.com/watch?v=example456',
                'thumbnail_url' => '/images/gallery-3.JPG',
                'duration' => 300, // 5 minutes
                'views' => 12000,
                'likes' => 280,
                'category' => 'interviews',
                'tags' => ['interview', 'player', 'john-doe'],
                'featured' => true,
                'status' => 'published',
                'published_at' => now()->subDays(7),
                'sort_order' => 3,
            ],
            [
                'title' => 'Tournament Highlights: Quarter Finals',
                'description' => 'Best moments from the quarter final matches',
                'platform' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=example789',
                'thumbnail_url' => '/images/gallery-4.JPG',
                'duration' => 240, // 4 minutes
                'views' => 25000,
                'likes' => 650,
                'category' => 'matches',
                'tags' => ['highlights', 'quarter-finals', 'tournament'],
                'featured' => true,
                'status' => 'published',
                'published_at' => now()->subDays(2),
                'sort_order' => 4,
            ],
            [
                'title' => 'TikTok Challenge: Fan Edition',
                'description' => 'Fans participating in our tournament challenge',
                'platform' => 'tiktok',
                'video_url' => 'https://www.tiktok.com/@milimucup/video/example123',
                'thumbnail_url' => '/images/gallery-5.JPG',
                'duration' => 60, // 1 minute
                'views' => 18000,
                'likes' => 890,
                'category' => 'fans',
                'tags' => ['tiktok', 'challenge', 'fans'],
                'featured' => false,
                'status' => 'published',
                'published_at' => now()->subDays(1),
                'sort_order' => 5,
            ],
            [
                'title' => 'Award Ceremony 2024',
                'description' => 'Complete coverage of the annual award ceremony',
                'platform' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=award2024',
                'thumbnail_url' => '/images/gallery-6.JPG',
                'duration' => 900, // 15 minutes
                'views' => 35000,
                'likes' => 1200,
                'category' => 'awards',
                'tags' => ['awards', 'ceremony', '2024'],
                'featured' => true,
                'status' => 'published',
                'published_at' => now()->subDays(10),
                'sort_order' => 6,
            ],
            [
                'title' => 'Training Tips: Shooting Techniques',
                'description' => 'Professional tips for improving shooting accuracy',
                'platform' => 'vimeo',
                'video_url' => 'https://vimeo.com/example123',
                'thumbnail_url' => '/images/gallery-7.JPG',
                'duration' => 180, // 3 minutes
                'views' => 9500,
                'likes' => 420,
                'category' => 'tutorials',
                'tags' => ['training', 'tips', 'shooting'],
                'featured' => false,
                'status' => 'published',
                'published_at' => now()->subDays(4),
                'sort_order' => 7,
            ],
            [
                'title' => 'Tournament Registration Guide',
                'description' => 'Step-by-step guide on how to register for tournaments',
                'platform' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=registration-guide',
                'thumbnail_url' => '/images/gallery-8.JPG',
                'duration' => 360, // 6 minutes
                'views' => 22000,
                'likes' => 750,
                'category' => 'tutorials',
                'tags' => ['registration', 'guide', 'tutorial'],
                'featured' => false,
                'status' => 'published',
                'published_at' => now()->subDays(8),
                'sort_order' => 8,
            ],
        ];

        foreach ($videos as $video) {
            VlogVideo::create($video);
        }
    }
}
