<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Player;
use App\Models\User;
use App\Models\Team;
use Illuminate\Support\Facades\Hash;

class TeamPlayersSeeder extends Seeder
{
    public function run(): void
    {
        $teamId = 70;
        
        $team = Team::find($teamId);
        if (!$team) {
            $this->command->error("Team with ID {$teamId} not found!");
            return;
        }

        $this->command->info("Creating 15 players for team: {$team->name}");

        $players = [
            ['name' => 'Brian Ochieng', 'email' => 'brian.ochieng@example.com', 'display_name' => 'Brian Ochieng', 'football_position' => 'Goalkeeper', 'jersey_number' => 1, 'is_team_captain' => true, 'phone' => '+254712345678', 'date_of_birth' => '1995-03-15', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Nairobi', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'John Mwangi', 'email' => 'john.mwangi@example.com', 'display_name' => 'John Mwangi', 'football_position' => 'Defender', 'jersey_number' => 2, 'is_team_captain' => false, 'phone' => '+254712345679', 'date_of_birth' => '1993-07-22', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Mombasa', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Peter Kimani', 'email' => 'peter.kimani@example.com', 'display_name' => 'Peter Kimani', 'football_position' => 'Defender', 'jersey_number' => 3, 'is_team_captain' => false, 'phone' => '+254712345680', 'date_of_birth' => '1994-11-08', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Nakuru', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Advanced'],
            ['name' => 'David Otieno', 'email' => 'david.otieno@example.com', 'display_name' => 'David Otieno', 'football_position' => 'Defender', 'jersey_number' => 4, 'is_team_captain' => false, 'phone' => '+254712345681', 'date_of_birth' => '1992-05-14', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Kisumu', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'James Wanjiku', 'email' => 'james.wanjiku@example.com', 'display_name' => 'James Wanjiku', 'football_position' => 'Defender', 'jersey_number' => 5, 'is_team_captain' => false, 'phone' => '+254712345682', 'date_of_birth' => '1996-09-30', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Eldoret', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'semi_pro', 'experience_level' => 'Advanced'],
            ['name' => 'Michael Kiprop', 'email' => 'michael.kiprop@example.com', 'display_name' => 'Michael Kiprop', 'football_position' => 'Midfielder', 'jersey_number' => 6, 'is_team_captain' => false, 'phone' => '+254712345683', 'date_of_birth' => '1991-12-03', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Nairobi', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Samuel Njoroge', 'email' => 'samuel.njoroge@example.com', 'display_name' => 'Samuel Njoroge', 'football_position' => 'Midfielder', 'jersey_number' => 7, 'is_team_captain' => false, 'phone' => '+254712345684', 'date_of_birth' => '1993-04-18', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Thika', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Kevin Muthomi', 'email' => 'kevin.muthomi@example.com', 'display_name' => 'Kevin Muthomi', 'football_position' => 'Midfielder', 'jersey_number' => 8, 'is_team_captain' => false, 'phone' => '+254712345685', 'date_of_birth' => '1995-08-25', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Meru', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'semi_pro', 'experience_level' => 'Advanced'],
            ['name' => 'Victor Ochieng', 'email' => 'victor.ochieng@example.com', 'display_name' => 'Victor Ochieng', 'football_position' => 'Midfielder', 'jersey_number' => 10, 'is_team_captain' => false, 'phone' => '+254712345686', 'date_of_birth' => '1994-01-12', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Kakamega', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Collins Mutua', 'email' => 'collins.mutua@example.com', 'display_name' => 'Collins Mutua', 'football_position' => 'Midfielder', 'jersey_number' => 11, 'is_team_captain' => false, 'phone' => '+254712345687', 'date_of_birth' => '1996-06-07', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Machakos', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'semi_pro', 'experience_level' => 'Intermediate'],
            ['name' => 'Eric Wanyama', 'email' => 'eric.wanyama@example.com', 'display_name' => 'Eric Wanyama', 'football_position' => 'Forward', 'jersey_number' => 9, 'is_team_captain' => false, 'phone' => '+254712345688', 'date_of_birth' => '1992-10-20', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Nairobi', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Brian Masika', 'email' => 'brian.masika@example.com', 'display_name' => 'Brian Masika', 'football_position' => 'Forward', 'jersey_number' => 12, 'is_team_captain' => false, 'phone' => '+254712345689', 'date_of_birth' => '1997-02-14', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Kisii', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'semi_pro', 'experience_level' => 'Advanced'],
            ['name' => 'Daniel Kipchoge', 'email' => 'daniel.kipchoge@example.com', 'display_name' => 'Daniel Kipchoge', 'football_position' => 'Forward', 'jersey_number' => 13, 'is_team_captain' => false, 'phone' => '+254712345690', 'date_of_birth' => '1995-12-01', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Eldoret', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Professional', 'experience_level' => 'Expert'],
            ['name' => 'Paul Mwangi', 'email' => 'paul.mwangi@example.com', 'display_name' => 'Paul Mwangi', 'football_position' => 'Midfielder', 'jersey_number' => 14, 'is_team_captain' => false, 'phone' => '+254712345691', 'date_of_birth' => '1998-03-28', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Nyeri', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Amateur', 'experience_level' => 'Intermediate'],
            ['name' => 'Mark Kiprotich', 'email' => 'mark.kiprotich@example.com', 'display_name' => 'Mark Kiprotich', 'football_position' => 'Defender', 'jersey_number' => 15, 'is_team_captain' => false, 'phone' => '+254712345692', 'date_of_birth' => '1999-07-15', 'gender' => 'Male', 'country' => 'Kenya', 'city' => 'Kericho', 'status' => 'active', 'verification_status' => 'verified', 'player_type' => 'Amateur', 'experience_level' => 'Beginner'],
        ];

        foreach ($players as $playerData) {
            $user = User::create([
                'name' => $playerData['name'],
                'email' => $playerData['email'],
                'password' => Hash::make('password123'),
                'phone' => $playerData['phone'],
                'user_type' => 'player',
                'profile_complete' => true,
                'payment_status' => 'completed',
                'terms_accepted_at' => now(),
            ]);

            Player::create([
                'user_id' => $user->id,
                'team_id' => $teamId,
                'display_name' => $playerData['display_name'],
                'football_position' => $playerData['football_position'],
                'jersey_number' => $playerData['jersey_number'],
                'is_team_captain' => $playerData['is_team_captain'],
                'phone' => $playerData['phone'],
                'date_of_birth' => $playerData['date_of_birth'],
                'gender' => $playerData['gender'],
                'country' => $playerData['country'],
                'city' => $playerData['city'],
                'status' => $playerData['status'],
                'verification_status' => $playerData['verification_status'],
                'player_type' => $playerData['player_type'],
                'experience_level' => $playerData['experience_level'],
                'global_rating' => rand(70, 95),
                'tournament_rating' => rand(70, 95),
                'tournament_matches_played' => rand(5, 50),
                'tournament_matches_won' => rand(3, 30),
                'tournament_win_rate' => rand(60, 90),
                'is_public_profile' => true,
                'allow_messages' => true,
                'show_contact_info' => true,
                'registered_at' => now(),
                'last_active_at' => now(),
            ]);

            $this->command->info("Created player: {$playerData['display_name']} (#{$playerData['jersey_number']}) - {$playerData['football_position']}");
        }

        $this->command->info("Successfully created 15 players for team: {$team->name}");
    }
}
