<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class TeamPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            [
                'name' => 'teams.view',
                'display_name' => 'View Teams',
                'description' => 'View team list and details',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 1,
                'metadata' => [
                    'icon' => 'eye',
                    'color' => 'blue',
                    'features' => ['list', 'show', 'search', 'filter']
                ]
            ],
            [
                'name' => 'teams.create',
                'display_name' => 'Create Teams',
                'description' => 'Create new teams and register them for tournaments',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 2,
                'metadata' => [
                    'icon' => 'plus',
                    'color' => 'green',
                    'features' => ['create', 'register', 'bulk_create']
                ]
            ],
            [
                'name' => 'teams.edit',
                'display_name' => 'Edit Teams',
                'description' => 'Edit existing team information and settings',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 3,
                'metadata' => [
                    'icon' => 'edit',
                    'color' => 'orange',
                    'features' => ['update', 'modify', 'settings']
                ]
            ],
            [
                'name' => 'teams.delete',
                'display_name' => 'Delete Teams',
                'description' => 'Delete teams and remove them from tournaments',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 4,
                'metadata' => [
                    'icon' => 'trash',
                    'color' => 'red',
                    'features' => ['delete', 'remove', 'bulk_delete']
                ]
            ],
            [
                'name' => 'teams.approve',
                'display_name' => 'Approve Teams',
                'description' => 'Approve or reject teams for tournament participation',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 5,
                'metadata' => [
                    'icon' => 'check-circle',
                    'color' => 'green',
                    'features' => ['approve', 'reject', 'first_approve', 'second_approve', 'bulk_approve']
                ]
            ],
            [
                'name' => 'teams.manage_payments',
                'display_name' => 'Manage Team Payments',
                'description' => 'Manually add, edit, or verify team registration payments',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 5.5,
                'metadata' => [
                    'icon' => 'dollar-sign',
                    'color' => 'green',
                    'features' => ['add_payment', 'verify_payment', 'edit_payment', 'view_payment_history']
                ]
            ],
            [
                'name' => 'teams.manage',
                'display_name' => 'Manage Teams',
                'description' => 'Full team management access including all operations',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 6,
                'metadata' => [
                    'icon' => 'settings',
                    'color' => 'purple',
                    'features' => ['all_operations', 'admin_access']
                ]
            ],
            [
                'name' => 'teams.export',
                'display_name' => 'Export Teams',
                'description' => 'Export team data and reports',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 7,
                'metadata' => [
                    'icon' => 'download',
                    'color' => 'blue',
                    'features' => ['export', 'reports', 'csv', 'pdf']
                ]
            ],
            [
                'name' => 'teams.import',
                'display_name' => 'Import Teams',
                'description' => 'Import team data from external sources',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 8,
                'metadata' => [
                    'icon' => 'upload',
                    'color' => 'green',
                    'features' => ['import', 'bulk_import', 'csv_upload']
                ]
            ],
            [
                'name' => 'teams.statistics',
                'display_name' => 'View Team Statistics',
                'description' => 'Access to team statistics and analytics',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 9,
                'metadata' => [
                    'icon' => 'bar-chart',
                    'color' => 'purple',
                    'features' => ['analytics', 'statistics', 'reports']
                ]
            ],
            [
                'name' => 'teams.notifications',
                'display_name' => 'Manage Team Notifications',
                'description' => 'Send notifications to teams and manage communication',
                'category' => 'teams',
                'is_system' => true,
                'is_active' => true,
                'sort_order' => 10,
                'metadata' => [
                    'icon' => 'bell',
                    'color' => 'orange',
                    'features' => ['notifications', 'messages', 'alerts']
                ]
            ]
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }

        if ($this->command) {
            $this->command->info('Team permissions seeded successfully!');
        }
    }
}
