<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;

class TeamManagerRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Team Manager role
        $teamManagerRole = Role::updateOrCreate(
            ['name' => 'team_manager'],
            [
                'name' => 'team_manager',
                'display_name' => 'Team Manager',
                'description' => 'Team manager with administrative access to their team',
                'permissions' => [
                    'teams.view',
                    'teams.edit',
                    'players.view',
                    'players.create',
                    'players.edit',
                    'matches.view',
                    'tournaments.view',
                    'dashboard.view',
                ],
                'is_system' => true,
                'is_active' => true,
                'priority' => 60,
                'color' => 'bg-indigo-600',
                'icon' => 'user-cog',
            ]
        );

        // Get the permissions for the team manager role
        $permissionNames = [
            'teams.view',
            'teams.edit',
            'players.view',
            'players.create',
            'players.edit',
            'matches.view',
            'tournaments.view',
            'dashboard.view',
        ];

        // Sync permissions via relationships
        $permissionIds = Permission::whereIn('name', $permissionNames)
            ->where('is_active', true)
            ->pluck('id')
            ->toArray();
        
        $teamManagerRole->permissions()->sync($permissionIds);

        $this->command->info('Team Manager role created successfully!');
    }
}
