<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PrizeAward;
use App\Models\Tournament;

class PrizeAwardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first tournament or create a default one
        $tournament = Tournament::first();
        if (!$tournament) {
            $tournament = Tournament::create([
                'name' => 'The Milimus Tournament 2024',
                'slug' => 'milimus-tournament-2024',
                'description' => 'The premier football tournament of the year',
                'type' => 'single_elimination',
                'start_date' => now()->addDays(30),
                'end_date' => now()->addDays(45),
                'registration_start' => now()->subDays(10),
                'registration_end' => now()->addDays(20),
                'max_teams' => 32,
                'entry_fee' => 500.00,
                'is_active' => true,
            ]);
        }

        $prizeAwardsData = [
            // Team Awards
            [
                'tournament_id' => $tournament->id,
                'category' => 'team',
                'position' => '1st',
                'title' => 'Champions Trophy',
                'description' => 'The ultimate prize for the tournament champions. This prestigious trophy represents excellence, teamwork, and dedication to the beautiful game.',
                'prize_value' => 10000.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Championship medals for all players, trophy presentation ceremony, media coverage, and automatic qualification for next year\'s tournament.',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'team',
                'position' => '2nd',
                'title' => 'Runners-up Trophy',
                'description' => 'Recognition for the second-place team\'s outstanding performance throughout the tournament.',
                'prize_value' => 5000.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Silver medals for all players, trophy presentation ceremony, and media recognition.',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'team',
                'position' => '3rd',
                'title' => 'Third Place Trophy',
                'description' => 'Celebrating the third-place team\'s achievement and competitive spirit.',
                'prize_value' => 2500.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Bronze medals for all players and trophy presentation ceremony.',
                'is_active' => true,
                'sort_order' => 3,
            ],

            // Individual Awards
            [
                'tournament_id' => $tournament->id,
                'category' => 'individual',
                'position' => 'special',
                'title' => 'Golden Boot Award',
                'description' => 'Awarded to the player who scores the most goals throughout the tournament.',
                'prize_value' => 1000.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Golden boot trophy, certificate of achievement, and media spotlight.',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'individual',
                'position' => 'special',
                'title' => 'Best Player Award',
                'description' => 'Recognizing the most outstanding player of the tournament based on overall performance.',
                'prize_value' => 1000.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'MVP trophy, certificate of achievement, and exclusive interview opportunity.',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'individual',
                'position' => 'special',
                'title' => 'Best Goalkeeper Award',
                'description' => 'Awarded to the goalkeeper with the most clean sheets and outstanding saves.',
                'prize_value' => 750.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Golden gloves trophy and certificate of achievement.',
                'is_active' => true,
                'sort_order' => 6,
            ],

            // Performance Awards
            [
                'tournament_id' => $tournament->id,
                'category' => 'performance',
                'position' => 'special',
                'title' => 'Most Improved Team',
                'description' => 'Recognizing the team that showed the greatest improvement throughout the tournament.',
                'prize_value' => 500.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Improvement trophy and certificate for all team members.',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'performance',
                'position' => 'special',
                'title' => 'Best Comeback Award',
                'description' => 'Awarded to the team that made the most remarkable comeback during the tournament.',
                'prize_value' => 500.00,
                'prize_type' => 'mixed',
                'additional_benefits' => 'Comeback trophy and special recognition ceremony.',
                'is_active' => true,
                'sort_order' => 8,
            ],

            // Fair Play Awards
            [
                'tournament_id' => $tournament->id,
                'category' => 'fair_play',
                'position' => 'special',
                'title' => 'Fair Play Award',
                'description' => 'Recognizing the team that best exemplifies sportsmanship, respect, and fair play throughout the tournament.',
                'prize_value' => 0.00,
                'prize_type' => 'trophy',
                'additional_benefits' => 'Fair play trophy, certificate of sportsmanship, and special recognition in tournament records.',
                'is_active' => true,
                'sort_order' => 9,
            ],

            // Special Recognition
            [
                'tournament_id' => $tournament->id,
                'category' => 'special',
                'position' => 'participation',
                'title' => 'Participation Certificate',
                'description' => 'Certificate of participation for all teams that competed in the tournament.',
                'prize_value' => 0.00,
                'prize_type' => 'certificate',
                'additional_benefits' => 'Digital certificate, tournament badge, and social media recognition.',
                'is_active' => true,
                'sort_order' => 10,
            ],
            [
                'tournament_id' => $tournament->id,
                'category' => 'special',
                'position' => 'special',
                'title' => 'Tournament Ambassador',
                'description' => 'Special recognition for outstanding contribution to the tournament community.',
                'prize_value' => 0.00,
                'prize_type' => 'certificate',
                'additional_benefits' => 'Ambassador certificate, special badge, and invitation to next year\'s tournament planning committee.',
                'is_active' => true,
                'sort_order' => 11,
            ],
        ];

        foreach ($prizeAwardsData as $prizeAwardData) {
            PrizeAward::create($prizeAwardData);
        }

        $this->command->info('Prize awards seeded successfully!');
    }
}
