<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            // Dashboard
            [
                'name' => 'dashboard.view',
                'display_name' => 'View Dashboard',
                'description' => 'Access to admin dashboard',
                'category' => 'dashboard',
                'is_system' => true,
                'sort_order' => 1,
            ],

            // Tournaments
            [
                'name' => 'tournaments.view',
                'display_name' => 'View Tournaments',
                'description' => 'View tournament list and details',
                'category' => 'tournaments',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'tournaments.create',
                'display_name' => 'Create Tournaments',
                'description' => 'Create new tournaments',
                'category' => 'tournaments',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'tournaments.edit',
                'display_name' => 'Edit Tournaments',
                'description' => 'Edit existing tournaments',
                'category' => 'tournaments',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'tournaments.delete',
                'display_name' => 'Delete Tournaments',
                'description' => 'Delete tournaments',
                'category' => 'tournaments',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'tournaments.manage',
                'display_name' => 'Manage Tournaments',
                'description' => 'Full tournament management access',
                'category' => 'tournaments',
                'is_system' => true,
                'sort_order' => 5,
            ],

            // Players
            [
                'name' => 'players.view',
                'display_name' => 'View Players',
                'description' => 'View player list and details',
                'category' => 'players',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'players.create',
                'display_name' => 'Create Players',
                'description' => 'Create new players',
                'category' => 'players',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'players.edit',
                'display_name' => 'Edit Players',
                'description' => 'Edit existing players',
                'category' => 'players',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'players.delete',
                'display_name' => 'Delete Players',
                'description' => 'Delete players',
                'category' => 'players',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'players.manage',
                'display_name' => 'Manage Players',
                'description' => 'Full player management access',
                'category' => 'players',
                'is_system' => true,
                'sort_order' => 5,
            ],

            // Teams
            [
                'name' => 'teams.view',
                'display_name' => 'View Teams',
                'description' => 'View team list and details',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'teams.create',
                'display_name' => 'Create Teams',
                'description' => 'Create new teams',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'teams.edit',
                'display_name' => 'Edit Teams',
                'description' => 'Edit existing teams',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'teams.delete',
                'display_name' => 'Delete Teams',
                'description' => 'Delete teams',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'teams.approve',
                'display_name' => 'Approve Teams',
                'description' => 'Approve or reject teams for tournament participation',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'teams.manage',
                'display_name' => 'Manage Teams',
                'description' => 'Full team management access',
                'category' => 'teams',
                'is_system' => true,
                'sort_order' => 6,
            ],

            // Matches
            [
                'name' => 'matches.view',
                'display_name' => 'View Matches',
                'description' => 'View match list and details',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'matches.create',
                'display_name' => 'Create Matches',
                'description' => 'Create new matches',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'matches.edit',
                'display_name' => 'Edit Matches',
                'description' => 'Edit existing matches',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'matches.delete',
                'display_name' => 'Delete Matches',
                'description' => 'Delete matches',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'matches.start',
                'display_name' => 'Start Matches',
                'description' => 'Start matches',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'matches.complete',
                'display_name' => 'Complete Matches',
                'description' => 'Complete and finalize matches',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'matches.verify',
                'display_name' => 'Verify Matches',
                'description' => 'Verify match results',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'matches.manage',
                'display_name' => 'Manage Matches',
                'description' => 'Full match management access',
                'category' => 'matches',
                'is_system' => true,
                'sort_order' => 8,
            ],

            // Brackets
            [
                'name' => 'brackets.view',
                'display_name' => 'View Brackets',
                'description' => 'View tournament brackets',
                'category' => 'brackets',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'brackets.create',
                'display_name' => 'Create Brackets',
                'description' => 'Create tournament brackets',
                'category' => 'brackets',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'brackets.edit',
                'display_name' => 'Edit Brackets',
                'description' => 'Edit tournament brackets',
                'category' => 'brackets',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'brackets.delete',
                'display_name' => 'Delete Brackets',
                'description' => 'Delete tournament brackets',
                'category' => 'brackets',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'brackets.manage',
                'display_name' => 'Manage Brackets',
                'description' => 'Full bracket management access',
                'category' => 'brackets',
                'is_system' => true,
                'sort_order' => 5,
            ],

            // Users
            [
                'name' => 'users.view',
                'display_name' => 'View Users',
                'description' => 'View user list and details',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'users.create',
                'display_name' => 'Create Users',
                'description' => 'Create new users',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'users.edit',
                'display_name' => 'Edit Users',
                'description' => 'Edit existing users',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'users.delete',
                'display_name' => 'Delete Users',
                'description' => 'Delete users',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'users.impersonate',
                'display_name' => 'Impersonate Users',
                'description' => 'Impersonate other users',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'users.manage',
                'display_name' => 'Manage Users',
                'description' => 'Full user management access',
                'category' => 'users',
                'is_system' => true,
                'sort_order' => 6,
            ],

            // Roles
            [
                'name' => 'roles.view',
                'display_name' => 'View Roles',
                'description' => 'View role list and details',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'roles.create',
                'display_name' => 'Create Roles',
                'description' => 'Create new roles',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'roles.edit',
                'display_name' => 'Edit Roles',
                'description' => 'Edit existing roles',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'roles.delete',
                'display_name' => 'Delete Roles',
                'description' => 'Delete roles',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'roles.assign',
                'display_name' => 'Assign Roles',
                'description' => 'Assign roles to users',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'roles.manage',
                'display_name' => 'Manage Roles',
                'description' => 'Full role management access',
                'category' => 'roles',
                'is_system' => true,
                'sort_order' => 6,
            ],

            // Permissions
            [
                'name' => 'permissions.view',
                'display_name' => 'View Permissions',
                'description' => 'View permission list and details',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'permissions.create',
                'display_name' => 'Create Permissions',
                'description' => 'Create new permissions',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'permissions.edit',
                'display_name' => 'Edit Permissions',
                'description' => 'Edit existing permissions',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'permissions.delete',
                'display_name' => 'Delete Permissions',
                'description' => 'Delete permissions',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'permissions.assign',
                'display_name' => 'Assign Permissions',
                'description' => 'Assign permissions to roles',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'permissions.manage',
                'display_name' => 'Manage Permissions',
                'description' => 'Full permission management access',
                'category' => 'permissions',
                'is_system' => true,
                'sort_order' => 6,
            ],

            // Payments
            [
                'name' => 'payments.view',
                'display_name' => 'View Payments',
                'description' => 'View payment list and details',
                'category' => 'payments',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'payments.manage',
                'display_name' => 'Manage Payments',
                'description' => 'Full payment management access',
                'category' => 'payments',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'payments.refund',
                'display_name' => 'Refund Payments',
                'description' => 'Process payment refunds',
                'category' => 'payments',
                'is_system' => true,
                'sort_order' => 3,
            ],

            // Settings
            [
                'name' => 'settings.view',
                'display_name' => 'View Settings',
                'description' => 'View system settings',
                'category' => 'settings',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'settings.edit',
                'display_name' => 'Edit Settings',
                'description' => 'Edit system settings',
                'category' => 'settings',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'settings.system',
                'display_name' => 'System Settings',
                'description' => 'Access critical system settings',
                'category' => 'settings',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'settings.manage',
                'display_name' => 'Manage Tournament Settings',
                'description' => 'Manage tournament configuration settings',
                'category' => 'settings',
                'is_system' => true,
                'sort_order' => 4,
            ],

            // Media
            [
                'name' => 'media.view',
                'display_name' => 'View Media',
                'description' => 'View media files',
                'category' => 'media',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'media.upload',
                'display_name' => 'Upload Media',
                'description' => 'Upload new media files',
                'category' => 'media',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'media.edit',
                'display_name' => 'Edit Media',
                'description' => 'Edit media files',
                'category' => 'media',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'media.delete',
                'display_name' => 'Delete Media',
                'description' => 'Delete media files',
                'category' => 'media',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'media.manage',
                'display_name' => 'Manage Media',
                'description' => 'Full media management access',
                'category' => 'media',
                'is_system' => true,
                'sort_order' => 5,
            ],

            // Vlog Videos
            [
                'name' => 'vlog.view',
                'display_name' => 'View Vlog Videos',
                'description' => 'View vlog video list and details',
                'category' => 'vlog',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'vlog.create',
                'display_name' => 'Create Vlog Videos',
                'description' => 'Create new vlog videos',
                'category' => 'vlog',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'vlog.edit',
                'display_name' => 'Edit Vlog Videos',
                'description' => 'Edit existing vlog videos',
                'category' => 'vlog',
                'is_system' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'vlog.delete',
                'display_name' => 'Delete Vlog Videos',
                'description' => 'Delete vlog videos',
                'category' => 'vlog',
                'is_system' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'vlog.manage',
                'display_name' => 'Manage Vlog Videos',
                'description' => 'Full vlog video management access',
                'category' => 'vlog',
                'is_system' => true,
                'sort_order' => 5,
            ],

            // Analytics
            [
                'name' => 'analytics.view',
                'display_name' => 'View Analytics',
                'description' => 'View system analytics',
                'category' => 'analytics',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'analytics.export',
                'display_name' => 'Export Analytics',
                'description' => 'Export analytics data',
                'category' => 'analytics',
                'is_system' => true,
                'sort_order' => 2,
            ],

            // System
            [
                'name' => 'system.logs',
                'display_name' => 'View System Logs',
                'description' => 'Access system logs',
                'category' => 'system',
                'is_system' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'system.backup',
                'display_name' => 'System Backup',
                'description' => 'Create and manage system backups',
                'category' => 'system',
                'is_system' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'system.maintenance',
                'display_name' => 'System Maintenance',
                'description' => 'Access system maintenance features',
                'category' => 'system',
                'is_system' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($permissions as $permissionData) {
            Permission::updateOrCreate(
                ['name' => $permissionData['name']],
                $permissionData
            );
        }

        $this->command->info('Permissions seeded successfully! Created ' . count($permissions) . ' permissions.');
    }
}