<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Services\NotificationRegistryService;

class NotificationSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $registryService = new NotificationRegistryService();
        
        $result = $registryService->syncNotifications();

        $this->command->info("Notification settings synced successfully!");
        $this->command->info("Total: {$result['total']}");
        $this->command->info("Created: {$result['created']}");
        $this->command->info("Updated: {$result['updated']}");
        
        // Show breakdown by category
        $counts = $registryService->getCategoryCounts();
        $this->command->info("\nBreakdown by category:");
        foreach ($counts as $category => $count) {
            $this->command->info("  - {$category}: {$count}");
        }
    }
}

