<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Frontend\HeroSlide;
use App\Models\Frontend\NewsArticle;
use App\Models\Frontend\GalleryImage;
use App\Models\Frontend\Sponsor;
use App\Models\Frontend\Testimonial;
use App\Models\Frontend\TournamentHighlight;
use App\Models\Frontend\TournamentAchievement;
use App\Models\Frontend\Fixture;

class FrontendDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seed Hero Slides
        $heroSlides = [
            [
                'title' => 'The Milimus Tournament',
                'subtitle' => 'Join the most prestigious football tournament in the region. Experience the thrill of competitive football with the best teams.',
                'bg_image' => '/images/hero-1.JPG',
                'cta_primary' => 'Register Your Team',
                'cta_secondary' => 'View Fixtures',
                'cta_primary_url' => '/register',
                'cta_secondary_url' => '/fixtures',
                'sort_order' => 1,
                'status' => 'published',
                'active' => true,
            ],
            [
                'title' => 'Where Legends Are Born',
                'subtitle' => 'Compete against the finest teams in a tournament designed to showcase talent and determination.',
                'bg_image' => '/images/hero-2.JPG',
                'cta_primary' => 'Join Tournament',
                'cta_secondary' => 'Tournament Rules',
                'cta_primary_url' => '/register',
                'cta_secondary_url' => '/rules',
                'sort_order' => 2,
                'status' => 'published',
                'active' => true,
            ],
            [
                'title' => 'Championship Glory Awaits',
                'subtitle' => 'The best teams compete for glory in a tournament that celebrates the beautiful game.',
                'bg_image' => '/images/hero.jpg',
                'cta_primary' => 'Get Started',
                'cta_secondary' => 'Prize Pool',
                'cta_primary_url' => '/register',
                'cta_secondary_url' => '/prizes',
                'sort_order' => 3,
                'status' => 'published',
                'active' => true,
            ],
        ];

        foreach ($heroSlides as $slide) {
            HeroSlide::updateOrCreate(
                ['title' => $slide['title']],
                $slide
            );
        }

        // Seed News Articles
        $newsArticles = [
            [
                'title' => 'Registration Opens for The Milimus Tournament 2025',
                'slug' => 'registration-opens-for-the-milimus-tournament-2025',
                'excerpt' => 'The Milimus Tournament 2025 registration is now officially open! Teams from across the region can submit their applications for the most prestigious football competition. With a record-breaking prize pool of Ksh. 70,000 and professional facilities, this year\'s tournament promises to be the biggest yet.',
                'content' => '<p>The Milimus Tournament 2025 registration is now officially open! Teams from across the region can submit their applications for the most prestigious football competition. With a record-breaking prize pool of Ksh. 70,000 and professional facilities, this year\'s tournament promises to be the biggest yet.</p><h2>Early Bird Registration</h2><p>Early bird registration is available until March 15th with special discounts for returning teams. This limited-time offer provides teams with:</p><ul><li>20% discount on registration fees</li><li>Priority access to training facilities</li><li>Exclusive merchandise package</li><li>Guaranteed accommodation options</li></ul>',
                'category' => 'registration',
                'author' => 'Tournament Committee',
                'author_image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?auto=format&fit=crop&w=100&q=80',
                'date' => '2025-02-15',
                'read_time' => '5 min read',
                'image' => 'https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=1200&q=80',
                'tags' => ['Registration', 'Tournament', '2025', 'Football'],
                'views' => 1247,
                'likes' => 89,
                'featured' => true,
                'status' => 'published',
                'published_at' => '2025-02-15',
            ],
            [
                'title' => 'Lwanda K FC Wins Milimus Tournament Cup 4th Edition',
                'slug' => 'lwanda-k-fc-wins-milimus-tournament-cup-4th-edition',
                'excerpt' => 'In a dramatic penalty shootout, Lwanda K FC emerged victorious over Kambiri FC to claim the Milimus Tournament Cup 4th Edition. The match was intense, with both teams displaying exceptional skill and determination.',
                'content' => '<p>In a dramatic penalty shootout, Lwanda K FC emerged victorious over Kambiri FC to claim the Milimus Tournament Cup 4th Edition. The match was intense, with both teams displaying exceptional skill and determination. Fans were treated to a thrilling finale as Lwanda K FC clinched the win with a 4-3 score in penalties.</p>',
                'category' => 'teams',
                'author' => 'Sports Reporter',
                'date' => '2025-01-04',
                'read_time' => '2 min read',
                'image' => '/images/lwanda-k-fc.jpg',
                'tags' => ['Champions', 'Lwanda K FC', 'Final'],
                'views' => 856,
                'likes' => 42,
                'featured' => false,
                'status' => 'published',
                'published_at' => '2025-01-04',
            ],
        ];

        foreach ($newsArticles as $article) {
            NewsArticle::updateOrCreate(
                ['slug' => $article['slug']],
                $article
            );
        }

        // Seed Gallery Images
        $galleryImages = [
            ['src' => '/images/gallery-1.JPG', 'alt' => 'Football match action', 'category' => 'matches', 'edition' => '4th', 'height' => 1, 'status' => 'published', 'sort_order' => 1],
            ['src' => '/images/gallery-2.JPG', 'alt' => 'Team celebration', 'category' => 'celebrations', 'edition' => '3rd', 'height' => 2, 'status' => 'published', 'sort_order' => 2],
            ['src' => '/images/gallery-3.JPG', 'alt' => 'Trophy presentation', 'category' => 'awards', 'edition' => '4th', 'height' => 1, 'status' => 'published', 'sort_order' => 3],
            ['src' => '/images/gallery-4.JPG', 'alt' => 'Stadium view', 'category' => 'venues', 'edition' => '2nd', 'height' => 2, 'status' => 'published', 'sort_order' => 4],
            ['src' => '/images/gallery-5.JPG', 'alt' => 'Player training', 'category' => 'training', 'edition' => '1st', 'height' => 1, 'status' => 'published', 'sort_order' => 5],
            ['src' => '/images/gallery-6.JPG', 'alt' => 'Fans cheering', 'category' => 'fans', 'edition' => '4th', 'height' => 2, 'status' => 'published', 'sort_order' => 6],
            ['src' => '/images/gallery-7.JPG', 'alt' => 'Team photo', 'category' => 'teams', 'edition' => '3rd', 'height' => 1, 'status' => 'published', 'sort_order' => 7],
            ['src' => '/images/gallery-8.JPG', 'alt' => 'Match highlights', 'category' => 'matches', 'edition' => '2nd', 'height' => 2, 'status' => 'published', 'sort_order' => 8],
            ['src' => '/images/gallery-9.JPG', 'alt' => 'Match highlights', 'category' => 'matches', 'edition' => '2nd', 'height' => 1, 'status' => 'published', 'sort_order' => 9],
            ['src' => '/images/gallery-10.JPG', 'alt' => 'Match highlights', 'category' => 'matches', 'edition' => '2nd', 'height' => 1, 'status' => 'published', 'sort_order' => 10],
            ['src' => '/images/gallery-11.JPG', 'alt' => 'Match highlights', 'category' => 'matches', 'edition' => '2nd', 'height' => 1, 'status' => 'published', 'sort_order' => 11],
            ['src' => '/images/gallery-12.JPG', 'alt' => 'Match highlights', 'category' => 'matches', 'edition' => '2nd', 'height' => 1, 'status' => 'published', 'sort_order' => 12],
        ];

        foreach ($galleryImages as $image) {
            GalleryImage::updateOrCreate(
                ['src' => $image['src']],
                $image
            );
        }

        // Seed Tournament Highlights
        $tournamentHighlights = [
            ['icon' => '🏆', 'title' => '4th Edition', 'description' => 'The biggest tournament yet', 'value' => '2024', 'color' => 'text-yellow-600', 'sort_order' => 1, 'active' => true],
            ['icon' => '⚽', 'title' => '32 Teams', 'description' => 'From across the region', 'value' => '32+', 'color' => 'text-green-600', 'sort_order' => 2, 'active' => true],
            ['icon' => '💰', 'title' => 'Ksh. 70,000 Prize Pool', 'description' => 'Record-breaking rewards', 'value' => 'Ksh. 70K', 'color' => 'text-blue-600', 'sort_order' => 3, 'active' => true],
            ['icon' => '🎯', 'title' => '64 Matches', 'description' => 'Over 3 weeks', 'value' => '64+', 'color' => 'text-red-600', 'sort_order' => 4, 'active' => true],
        ];

        foreach ($tournamentHighlights as $highlight) {
            TournamentHighlight::updateOrCreate(
                ['title' => $highlight['title']],
                $highlight
            );
        }

        // Seed Tournament Achievements
        $tournamentAchievements = [
            ['year' => 2022, 'title' => '1st Edition', 'description' => 'Inaugural tournament with 16 teams', 'participants' => '16 Teams', 'sort_order' => 1, 'active' => true],
            ['year' => 2023, 'title' => '2nd Edition', 'description' => 'Expanded to 24 teams', 'participants' => '24 Teams', 'sort_order' => 2, 'active' => true],
            ['year' => 2024, 'title' => '3rd Edition', 'description' => 'Full capacity with 32 teams', 'participants' => '32 Teams', 'sort_order' => 3, 'active' => true],
            ['year' => 2025, 'title' => '4th Edition', 'description' => 'Record-breaking prize pool of Ksh. 70,000', 'participants' => '32 Teams', 'sort_order' => 4, 'active' => true],
        ];

        foreach ($tournamentAchievements as $achievement) {
            TournamentAchievement::updateOrCreate(
                ['year' => $achievement['year'], 'title' => $achievement['title']],
                $achievement
            );
        }

        // Seed Sponsors
        $sponsors = [
            ['name' => 'SportTech Pro', 'category' => 'equipment', 'logo' => '⚽', 'description' => 'Official equipment and training facilities provider', 'tier' => 'platinum', 'sort_order' => 1, 'active' => true],
            ['name' => 'MediaCorp', 'category' => 'media', 'logo' => '📺', 'description' => 'Live streaming and broadcast coverage', 'tier' => 'gold', 'sort_order' => 2, 'active' => true],
            ['name' => 'EnergyBoost', 'category' => 'nutrition', 'logo' => '🥤', 'description' => 'Official sports nutrition and hydration', 'tier' => 'silver', 'sort_order' => 3, 'active' => true],
            ['name' => 'SecureBank', 'category' => 'financial', 'logo' => '🏦', 'description' => 'Official banking and payment solutions', 'tier' => 'bronze', 'sort_order' => 4, 'active' => true],
        ];

        foreach ($sponsors as $sponsor) {
            Sponsor::updateOrCreate(
                ['name' => $sponsor['name']],
                $sponsor
            );
        }

        // Seed Testimonials
        $testimonials = [
            [
                'name' => 'Carlos Rodriguez',
                'role' => 'Team Captain',
                'team' => 'FC Barcelona Academy',
                'image' => '👨‍💼',
                'rating' => 5,
                'quote' => 'The Milimus Tournament provided us with the perfect platform to showcase our talent. The organization was professional and the competition was fierce.',
                'achievement' => 'Champion 2023',
                'year' => 2023,
                'sort_order' => 1,
                'active' => true,
                'featured' => true,
            ],
            [
                'name' => 'Maria Santos',
                'role' => 'Coach',
                'team' => 'Real Madrid Youth',
                'image' => '👩‍💼',
                'rating' => 5,
                'quote' => 'As a coach, I appreciate the high standards and fair play promoted by this tournament. It\'s a great learning experience for young players.',
                'achievement' => 'Runner-up 2022',
                'year' => 2022,
                'sort_order' => 2,
                'active' => true,
                'featured' => true,
            ],
            [
                'name' => 'Ahmed Hassan',
                'role' => 'Team Manager',
                'team' => 'Al Ahly Academy',
                'image' => '👨‍💼',
                'rating' => 5,
                'quote' => 'The facilities and hospitality were outstanding. The tournament organizers went above and beyond to ensure a great experience.',
                'achievement' => 'Semi-finalist 2023',
                'year' => 2023,
                'sort_order' => 3,
                'active' => true,
                'featured' => true,
            ],
        ];

        foreach ($testimonials as $testimonial) {
            Testimonial::updateOrCreate(
                ['name' => $testimonial['name'], 'team' => $testimonial['team']],
                $testimonial
            );
        }

        // Seed Fixtures - Temporarily commented out due to JSON format issue
        /*
        $fixtures = [
            [
                'date' => '2024-07-01',
                'time' => '15:00',
                'team_a' => ['name' => 'Lions FC', 'logo' => '/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png'],
                'team_b' => ['name' => 'Eagles United', 'logo' => 'https://images.unsplash.com/photo-1517649763962-0c623066013b?auto=format&fit=crop&w=60&q=80'],
                'venue' => 'Main Stadium',
                'status' => 'completed',
                'result' => '2 - 1',
                'sort_order' => 1,
                'active' => true,
            ],
            [
                'date' => '2024-07-02',
                'time' => '17:00',
                'team_a' => ['name' => 'Sharks', 'logo' => 'https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=60&q=80'],
                'team_b' => ['name' => 'Tigers', 'logo' => 'https://images.unsplash.com/photo-1464983953574-0892a716854b?auto=format&fit=crop&w=60&q=80'],
                'venue' => 'Field B',
                'status' => 'live',
                'result' => '1 - 1 (60\')',
                'sort_order' => 2,
                'active' => true,
            ],
            [
                'date' => '2024-07-03',
                'time' => '19:00',
                'team_a' => ['name' => 'Panthers', 'logo' => 'https://images.unsplash.com/photo-1505843273132-bc5c6f7d2c5e?auto=format&fit=crop&w=60&q=80'],
                'team_b' => ['name' => 'Falcons', 'logo' => '/lovable-uploads/18075074-5322-458c-b0cf-a75db311c3c0.png'],
                'venue' => 'Main Stadium',
                'status' => 'upcoming',
                'result' => '-',
                'sort_order' => 3,
                'active' => true,
            ],
        ];

        foreach ($fixtures as $fixture) {
            Fixture::create($fixture);
        }
        */

        $this->command->info('Frontend data seeded successfully!');
    }
} 