<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Formation;

class FormationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $formations = [
            // Popular Kenyan Formations
            [
                'name' => '4-4-2',
                'display_name' => 'Classic 4-4-2',
                'description' => 'The most popular formation in Kenyan football. Balanced with two strikers and solid midfield.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 20, 'y' => 30, 'label' => 'LB'],
                        ['x' => 40, 'y' => 30, 'label' => 'CB'],
                        ['x' => 60, 'y' => 30, 'label' => 'CB'],
                        ['x' => 80, 'y' => 30, 'label' => 'RB'],
                    ],
                    'midfielders' => [
                        ['x' => 25, 'y' => 50, 'label' => 'LM'],
                        ['x' => 45, 'y' => 50, 'label' => 'CM'],
                        ['x' => 55, 'y' => 50, 'label' => 'CM'],
                        ['x' => 75, 'y' => 50, 'label' => 'RM'],
                    ],
                    'forwards' => [
                        ['x' => 40, 'y' => 75, 'label' => 'ST'],
                        ['x' => 60, 'y' => 75, 'label' => 'ST'],
                    ]
                ],
                'category' => 'standard',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '4-3-3',
                'display_name' => 'Attacking 4-3-3',
                'description' => 'Popular for attacking play with three forwards. Used by many Kenyan teams.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 20, 'y' => 30, 'label' => 'LB'],
                        ['x' => 40, 'y' => 30, 'label' => 'CB'],
                        ['x' => 60, 'y' => 30, 'label' => 'CB'],
                        ['x' => 80, 'y' => 30, 'label' => 'RB'],
                    ],
                    'midfielders' => [
                        ['x' => 30, 'y' => 50, 'label' => 'CM'],
                        ['x' => 50, 'y' => 50, 'label' => 'CM'],
                        ['x' => 70, 'y' => 50, 'label' => 'CM'],
                    ],
                    'forwards' => [
                        ['x' => 25, 'y' => 75, 'label' => 'LW'],
                        ['x' => 50, 'y' => 75, 'label' => 'ST'],
                        ['x' => 75, 'y' => 75, 'label' => 'RW'],
                    ]
                ],
                'category' => 'attacking',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '3-5-2',
                'display_name' => 'Wing-Back 3-5-2',
                'description' => 'Defensive formation with wing-backs. Popular in Kenyan lower leagues.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 30, 'y' => 30, 'label' => 'CB'],
                        ['x' => 50, 'y' => 30, 'label' => 'CB'],
                        ['x' => 70, 'y' => 30, 'label' => 'CB'],
                    ],
                    'midfielders' => [
                        ['x' => 15, 'y' => 50, 'label' => 'LWB'],
                        ['x' => 35, 'y' => 50, 'label' => 'CM'],
                        ['x' => 50, 'y' => 50, 'label' => 'CM'],
                        ['x' => 65, 'y' => 50, 'label' => 'CM'],
                        ['x' => 85, 'y' => 50, 'label' => 'RWB'],
                    ],
                    'forwards' => [
                        ['x' => 40, 'y' => 75, 'label' => 'ST'],
                        ['x' => 60, 'y' => 75, 'label' => 'ST'],
                    ]
                ],
                'category' => 'defensive',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '4-2-3-1',
                'display_name' => 'Modern 4-2-3-1',
                'description' => 'Modern formation with two holding midfielders. Gaining popularity in Kenya.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 20, 'y' => 30, 'label' => 'LB'],
                        ['x' => 40, 'y' => 30, 'label' => 'CB'],
                        ['x' => 60, 'y' => 30, 'label' => 'CB'],
                        ['x' => 80, 'y' => 30, 'label' => 'RB'],
                    ],
                    'midfielders' => [
                        ['x' => 40, 'y' => 50, 'label' => 'CDM'],
                        ['x' => 60, 'y' => 50, 'label' => 'CDM'],
                        ['x' => 25, 'y' => 65, 'label' => 'LW'],
                        ['x' => 50, 'y' => 65, 'label' => 'CAM'],
                        ['x' => 75, 'y' => 65, 'label' => 'RW'],
                    ],
                    'forwards' => [
                        ['x' => 50, 'y' => 80, 'label' => 'ST'],
                    ]
                ],
                'category' => 'modern',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '5-4-1',
                'display_name' => 'Defensive 5-4-1',
                'description' => 'Very defensive formation. Used by underdog teams in Kenya.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 15, 'y' => 30, 'label' => 'LWB'],
                        ['x' => 30, 'y' => 30, 'label' => 'CB'],
                        ['x' => 50, 'y' => 30, 'label' => 'CB'],
                        ['x' => 70, 'y' => 30, 'label' => 'CB'],
                        ['x' => 85, 'y' => 30, 'label' => 'RWB'],
                    ],
                    'midfielders' => [
                        ['x' => 25, 'y' => 50, 'label' => 'LM'],
                        ['x' => 45, 'y' => 50, 'label' => 'CM'],
                        ['x' => 55, 'y' => 50, 'label' => 'CM'],
                        ['x' => 75, 'y' => 50, 'label' => 'RM'],
                    ],
                    'forwards' => [
                        ['x' => 50, 'y' => 75, 'label' => 'ST'],
                    ]
                ],
                'category' => 'defensive',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '4-1-4-1',
                'display_name' => 'Diamond 4-1-4-1',
                'description' => 'Formation with defensive midfielder. Popular in Kenyan Premier League.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 20, 'y' => 30, 'label' => 'LB'],
                        ['x' => 40, 'y' => 30, 'label' => 'CB'],
                        ['x' => 60, 'y' => 30, 'label' => 'CB'],
                        ['x' => 80, 'y' => 30, 'label' => 'RB'],
                    ],
                    'midfielders' => [
                        ['x' => 50, 'y' => 45, 'label' => 'CDM'],
                        ['x' => 25, 'y' => 60, 'label' => 'LM'],
                        ['x' => 45, 'y' => 60, 'label' => 'CM'],
                        ['x' => 55, 'y' => 60, 'label' => 'CM'],
                        ['x' => 75, 'y' => 60, 'label' => 'RM'],
                    ],
                    'forwards' => [
                        ['x' => 50, 'y' => 80, 'label' => 'ST'],
                    ]
                ],
                'category' => 'standard',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '3-4-3',
                'display_name' => 'Attacking 3-4-3',
                'description' => 'Very attacking formation. Used by top Kenyan teams.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 30, 'y' => 30, 'label' => 'CB'],
                        ['x' => 50, 'y' => 30, 'label' => 'CB'],
                        ['x' => 70, 'y' => 30, 'label' => 'CB'],
                    ],
                    'midfielders' => [
                        ['x' => 20, 'y' => 50, 'label' => 'LM'],
                        ['x' => 40, 'y' => 50, 'label' => 'CM'],
                        ['x' => 60, 'y' => 50, 'label' => 'CM'],
                        ['x' => 80, 'y' => 50, 'label' => 'RM'],
                    ],
                    'forwards' => [
                        ['x' => 25, 'y' => 75, 'label' => 'LW'],
                        ['x' => 50, 'y' => 75, 'label' => 'ST'],
                        ['x' => 75, 'y' => 75, 'label' => 'RW'],
                    ]
                ],
                'category' => 'attacking',
                'is_popular' => true,
                'country' => 'Kenya'
            ],
            [
                'name' => '4-5-1',
                'display_name' => 'Defensive 4-5-1',
                'description' => 'Defensive formation with packed midfield. Common in Kenyan lower divisions.',
                'positions' => [
                    'goalkeeper' => ['x' => 50, 'y' => 10, 'label' => 'GK'],
                    'defenders' => [
                        ['x' => 20, 'y' => 30, 'label' => 'LB'],
                        ['x' => 40, 'y' => 30, 'label' => 'CB'],
                        ['x' => 60, 'y' => 30, 'label' => 'CB'],
                        ['x' => 80, 'y' => 30, 'label' => 'RB'],
                    ],
                    'midfielders' => [
                        ['x' => 15, 'y' => 50, 'label' => 'LM'],
                        ['x' => 35, 'y' => 50, 'label' => 'CM'],
                        ['x' => 50, 'y' => 50, 'label' => 'CM'],
                        ['x' => 65, 'y' => 50, 'label' => 'CM'],
                        ['x' => 85, 'y' => 50, 'label' => 'RM'],
                    ],
                    'forwards' => [
                        ['x' => 50, 'y' => 75, 'label' => 'ST'],
                    ]
                ],
                'category' => 'defensive',
                'is_popular' => true,
                'country' => 'Kenya'
            ]
        ];

        foreach ($formations as $formation) {
            Formation::create($formation);
        }
    }
}
