<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Faq;

class FaqSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing FAQs
        Faq::truncate();

        // General Information FAQs
        $generalFaqs = [
            [
                'category' => 'general',
                'question' => 'What is The Milimus Tournament?',
                'answer' => 'The Milimus Tournament is a prestigious football competition that brings together teams from various regions to compete in a structured tournament format. We focus on promoting fair play, sportsmanship, and community engagement through football.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'When does the tournament take place?',
                'answer' => 'The tournament runs for 30 days, typically starting in the middle of the year. Exact dates are announced 3 months before the tournament begins. Check our website regularly for updates on registration and tournament dates.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'Where is the tournament held?',
                'answer' => 'The tournament is held at various football grounds across the region. Specific venue details are provided to registered teams closer to the tournament start date. All venues are equipped with proper facilities and meet safety standards.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'How many teams participate?',
                'answer' => 'We accommodate up to 16 teams in each tournament. Teams are selected based on their registration order and meeting all eligibility requirements. Early registration increases your chances of securing a spot.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'general',
                'question' => 'What is the tournament format?',
                'answer' => 'The tournament follows a group stage format followed by knockout rounds. Teams are divided into groups, and the top teams from each group advance to the elimination rounds. This ensures fair competition and exciting matches throughout the tournament.',
                'sort_order' => 5,
                'is_active' => true,
            ],
        ];

        // Team Registration FAQs
        $registrationFaqs = [
            [
                'category' => 'registration',
                'question' => 'How do I register my team?',
                'answer' => 'You can register your team by visiting our "Register Team" page on the website. You\'ll need to provide team information, player details, and required documents. Registration is free, but teams must meet all eligibility criteria.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'registration',
                'question' => 'What documents are required for registration?',
                'answer' => 'Required documents include: Team registration form, Player identification documents, Medical certificates for all players, Team manager/official contact information, and Proof of team insurance (if applicable).',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'registration',
                'question' => 'Can I register as an individual player?',
                'answer' => 'No, we only accept team registrations. Individual players must join an existing team or form a new team with other players. We encourage players to connect through our community forums to find teammates.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'registration',
                'question' => 'What is the registration deadline?',
                'answer' => 'Registration typically closes 2 weeks before the tournament begins. We recommend registering as early as possible as spots are limited and filled on a first-come, first-served basis.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'registration',
                'question' => 'Can I make changes to my team after registration?',
                'answer' => 'Minor changes like contact information can be updated until 1 week before the tournament. Player roster changes are allowed until 3 days before the tournament starts, but all new players must meet eligibility requirements.',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'registration',
                'question' => 'What are the team size requirements?',
                'answer' => 'Each team must have a minimum of 15 players and a maximum of 25 players. Teams must also have at least one team manager or coach. All players must be registered and meet the age requirements.',
                'sort_order' => 6,
                'is_active' => true,
            ],
        ];

        // Tournament Rules FAQs
        $tournamentFaqs = [
            [
                'category' => 'tournament',
                'question' => 'What are the age requirements?',
                'answer' => 'Players must be between 16 and 35 years old. Age verification is required during registration, and players may be asked to provide identification documents at any point during the tournament.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'How many players can be on a team?',
                'answer' => 'Each team can register up to 25 players, with 11 players on the field at any time. Teams must have a minimum of 15 registered players to be eligible for participation.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'What equipment is required?',
                'answer' => 'Teams must provide their own jerseys, shorts, socks, and shin guards. Football boots are required, and cleats must meet safety standards. The tournament provides match balls and goal posts.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'What happens if a match is cancelled due to weather?',
                'answer' => 'Matches cancelled due to weather conditions will be rescheduled. If rescheduling is not possible, the tournament committee will determine the outcome based on tournament rules and fair play principles.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'Are there any disciplinary rules?',
                'answer' => 'Yes, we have strict disciplinary rules. Red cards result in automatic suspension for the next match. Repeated violations may lead to team disqualification. We promote fair play and respect for all participants.',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'What are the substitution rules?',
                'answer' => 'Teams are allowed up to 5 substitutions per match. Substitutions can be made at any time during the match, but players who are substituted off cannot return to the field. All substitutions must be approved by the match officials.',
                'sort_order' => 6,
                'is_active' => true,
            ],
            [
                'category' => 'tournament',
                'question' => 'How are matches officiated?',
                'answer' => 'All matches are officiated by certified referees. We ensure that referees are experienced and impartial. Match officials have the final say on all decisions during the game, and their decisions are binding.',
                'sort_order' => 7,
                'is_active' => true,
            ],
        ];

        // Schedule & Fixtures FAQs
        $scheduleFaqs = [
            [
                'category' => 'schedule',
                'question' => 'How are fixtures determined?',
                'answer' => 'Fixtures are determined through a random draw after team registration closes. The tournament follows a group stage format followed by knockout rounds. Match schedules are published 1 week before the tournament begins.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'schedule',
                'question' => 'When are match schedules released?',
                'answer' => 'Match schedules are released 1 week before the tournament starts. Teams will receive their complete fixture list via email and can also view it on our website\'s fixtures page.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'schedule',
                'question' => 'Can match times be changed?',
                'answer' => 'Match times are generally fixed, but changes may be made in exceptional circumstances (weather, venue issues, etc.). Any changes will be communicated to teams at least 24 hours in advance.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'schedule',
                'question' => 'What happens if my team can\'t make a scheduled match?',
                'answer' => 'Teams must notify the tournament committee at least 24 hours before a match if they cannot participate. Failure to show up without notice may result in forfeit and potential disqualification from the tournament.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'schedule',
                'question' => 'How long are the matches?',
                'answer' => 'Each match consists of two 45-minute halves with a 15-minute halftime break. Extra time may be added for stoppages. In knockout rounds, extra time and penalty shootouts may be used to determine the winner.',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'schedule',
                'question' => 'What time do matches typically start?',
                'answer' => 'Matches are scheduled throughout the day, typically starting from 9:00 AM to 6:00 PM. Weekend matches may have extended hours. Teams will be notified of their specific match times in advance.',
                'sort_order' => 6,
                'is_active' => true,
            ],
        ];

        // Prizes & Awards FAQs
        $prizesFaqs = [
            [
                'category' => 'prizes',
                'question' => 'What prizes are available?',
                'answer' => 'We offer a total prize pool of Ksh. 150,000 including cash prizes, trophies, medals, and certificates. Champions receive Ksh. 50,000, runners-up get Ksh. 30,000, and third place receives Ksh. 20,000. Individual awards are also available.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'prizes',
                'question' => 'When are prizes awarded?',
                'answer' => 'Prizes are awarded immediately after the final match during the closing ceremony. All winners must be present to receive their prizes. Cash prizes are transferred within 30 days of the tournament\'s conclusion.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'prizes',
                'question' => 'Are there individual player awards?',
                'answer' => 'Yes, we have several individual awards including Best Player, Top Scorer, Best Goalkeeper, Most Valuable Player, Best Young Player, and Best Coach. These awards come with cash prizes and trophies.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'prizes',
                'question' => 'What is the Fair Play Award?',
                'answer' => 'The Fair Play Award recognizes the team that demonstrates the best sportsmanship throughout the tournament. This award comes with a Ksh. 10,000 prize and is determined by referee reports and tournament officials.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'prizes',
                'question' => 'How are individual awards determined?',
                'answer' => 'Individual awards are determined by a panel of judges including tournament officials, referees, and football experts. Statistics, performance, and sportsmanship are all considered in the selection process.',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'prizes',
                'question' => 'Are there participation certificates?',
                'answer' => 'Yes, all participating teams and players receive participation certificates. These certificates are awarded at the end of the tournament and serve as recognition for taking part in the competition.',
                'sort_order' => 6,
                'is_active' => true,
            ],
        ];

        // Support & Contact FAQs
        $supportFaqs = [
            [
                'category' => 'support',
                'question' => 'How can I contact the tournament organizers?',
                'answer' => 'You can contact us via email at info@milimustournament.com, phone at +254 700 000 000, or visit our office at [Office Address]. We also have active social media channels for quick updates and support.',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'support',
                'question' => 'What if I have a complaint or issue?',
                'answer' => 'We have a dedicated support team to handle all complaints and issues. Please contact us immediately if you encounter any problems. We aim to resolve all issues within 24 hours and maintain open communication throughout the process.',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'support',
                'question' => 'Is there technical support available?',
                'answer' => 'Yes, we provide technical support for website issues, registration problems, and other technical matters. Our support team is available during business hours and can be reached through our contact channels.',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'category' => 'support',
                'question' => 'How can I stay updated on tournament news?',
                'answer' => 'Follow us on social media, subscribe to our newsletter, and regularly check our website for updates. We also send important notifications via email and SMS to registered teams and participants.',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'category' => 'support',
                'question' => 'What are your business hours?',
                'answer' => 'Our office is open Monday to Friday from 9:00 AM to 5:00 PM, and Saturday from 9:00 AM to 1:00 PM. We are closed on Sundays and public holidays. For urgent matters outside business hours, please call our emergency hotline.',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'category' => 'support',
                'question' => 'How can I provide feedback about the tournament?',
                'answer' => 'We welcome feedback from all participants. You can provide feedback through our website contact form, email, or by speaking with tournament officials. Your feedback helps us improve future tournaments.',
                'sort_order' => 6,
                'is_active' => true,
            ],
        ];

        // Insert all FAQs
        $allFaqs = array_merge(
            $generalFaqs,
            $registrationFaqs,
            $tournamentFaqs,
            $scheduleFaqs,
            $prizesFaqs,
            $supportFaqs
        );

        foreach ($allFaqs as $faq) {
            Faq::create($faq);
        }

        $this->command->info('FAQs seeded successfully! Total FAQs created: ' . count($allFaqs));
    }
}
