<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class EmailPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            [
                'name' => 'emails.view',
                'display_name' => 'View Email Accounts',
                'description' => 'View email account credentials and settings',
                'category' => 'Email Management',
                'is_active' => true,
            ],
            [
                'name' => 'emails.create',
                'display_name' => 'Create Email Accounts',
                'description' => 'Create new email account credentials',
                'category' => 'Email Management',
                'is_active' => true,
            ],
            [
                'name' => 'emails.edit',
                'display_name' => 'Edit Email Accounts',
                'description' => 'Edit existing email account credentials and settings',
                'category' => 'Email Management',
                'is_active' => true,
            ],
            [
                'name' => 'emails.delete',
                'display_name' => 'Delete Email Accounts',
                'description' => 'Delete email account credentials',
                'category' => 'Email Management',
                'is_active' => true,
            ],
            [
                'name' => 'emails.assign',
                'display_name' => 'Manage User Access',
                'description' => 'Assign and manage user access to email accounts',
                'category' => 'Email Management',
                'is_active' => true,
            ],
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }
    }
}
