<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Tournament;
use App\Models\Player;
use App\Models\Team;
use App\Models\Bracket;
use App\Models\GameMatch;
use App\Models\Role;
use App\Models\Payment;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        echo "Starting database seeding...\n";

        // Seed permissions first, then roles
        $this->call([
            PermissionSeeder::class,
            RoleSeeder::class,
            TeamPermissionsSeeder::class,
            TeamManagerRoleSeeder::class,
            ApprovalPermissionsSeeder::class,
            EmailPermissionsSeeder::class,
            FaqPermissionSeeder::class,
            FaqSeeder::class,
            PrizeAwardPermissionSeeder::class,
            PrizeAwardSeeder::class,
            TournamentCategoryPermissionsSeeder::class,
            NotificationSettingsSeeder::class,
            TournamentSeeder::class,
            FrontendDataSeeder::class,
            DummyDataSeeder::class,
            MilimuCupTournamentSeeder::class,
            MilimuCupFixturesSeeder::class,
        ]);

        // Create Super Admin with ALL permissions
        echo "Creating Super Admin...\n";
        
        $superAdmin = User::create([
            'name' => 'Super Admin',
            'email' => 'admin@example.com',
            'password' => bcrypt('password'),
            'user_type' => 'team_manager',
            'profile_complete' => true,
            'email_verified_at' => now(),
            'payment_status' => 'not_required',
        ]);

        // Assign admin role (which has all permissions)
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $superAdmin->roles()->attach($adminRole->id, ['is_primary' => true]);
            
            // Sync ALL permissions to admin role
            $allPermissions = \App\Models\Permission::all();
            if ($allPermissions->isNotEmpty()) {
                $adminRole->permissions()->sync($allPermissions->pluck('id'));
                echo "✅ Admin role synced with all {$allPermissions->count()} permissions\n";
            }
            
            echo "✅ Super Admin role assigned\n";
        }

        echo "\n";
        echo "🎉 Super Admin Created!\n";
        echo "   Email: admin@example.com\n";
        echo "   Password: password\n";
        echo "   Role: Admin (with ALL permissions)\n";
        echo "\n";
       
        echo "Database seeding completed!\n";
    }
}
