<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tournaments', function (Blueprint $table) {
            // Add min/max players per team (separate from min/max participants which are for teams)
            $table->integer('min_players_per_team')->nullable()->after('max_participants')->default(11);
            $table->integer('max_players_per_team')->nullable()->after('min_players_per_team')->default(23);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tournaments', function (Blueprint $table) {
            $table->dropColumn(['min_players_per_team', 'max_players_per_team']);
        });
    }
};
