<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * The current password being used by the factory.
     */
    protected static ?string $password;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Western Kenya - Luhya community names
        $luhyaFirstNames = [
            // Male names
            'Wekesa', 'Wafula', 'Mukhwana', 'Wanyonyi', 'Mulongo', 'Wanyama', 'Barasa', 'Simiyu',
            'Shiundu', 'Waswa', 'Makokha', 'Wanjala', 'Wabwire', 'Waliaula', 'Wanyonyi', 'Masinde',
            'Wekulo', 'Wafula', 'Murunga', 'Wanyama', 'Khisa', 'Wanjala', 'Wanyonyi', 'Wafula',
            // Female names
            'Nekesa', 'Nafula', 'Naliaka', 'Nanjala', 'Nasimiyu', 'Nanyama', 'Naswa', 'Nabwire',
            'Namukose', 'Namarome', 'Nasambu', 'Nangila', 'Nanjala', 'Nafula', 'Nekesa', 'Naliaka'
        ];
        
        $luhyaLastNames = [
            'Wekesa', 'Wafula', 'Wanyama', 'Barasa', 'Simiyu', 'Wanyonyi', 'Mulongo', 'Mukhwana',
            'Makokha', 'Wanjala', 'Shiundu', 'Waswa', 'Masinde', 'Wabwire', 'Waliaula', 'Murunga',
            'Khisa', 'Wekulo', 'Namukose', 'Nasambu', 'Nangila', 'Shikuku', 'Mudavadi', 'Wamalwa',
            'Wetangula', 'Khalwale', 'Savula', 'Mulembe', 'Nabwera', 'Osotsi', 'Oparanya', 'Lusaka'
        ];
        
        $firstName = $luhyaFirstNames[array_rand($luhyaFirstNames)];
        $lastName = $luhyaLastNames[array_rand($luhyaLastNames)];
        $name = $firstName . ' ' . $lastName;
        
        return [
            'name' => $name,
            'email' => strtolower(str_replace(' ', '.', $name)) . fake()->unique()->numberBetween(1, 999) . '@' . fake()->randomElement(['gmail.com', 'yahoo.com', 'outlook.com', 'hotmail.com']),
            'email_verified_at' => now(),
            'password' => static::$password ??= Hash::make('password'),
            'remember_token' => Str::random(10),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
