<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Tournament>
 */
class TournamentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startDate = $this->faker->dateTimeBetween('now', '+2 months');
        $endDate = $this->faker->dateTimeBetween($startDate, '+6 months');
        
        // Western Kenya - Luhya region tournament names
        $tournamentNames = [
            'Kakamega County Championship',
            'Bungoma Football League',
            'Vihiga Golden Cup',
            'Busia Border Derby',
            'Mumias Sugar Belt Tournament',
            'Bukhungu Stadium Cup',
            'Western Kenya Premier League',
            'Luhya Unity Cup',
            'Kakamega Forest Championship',
            'Webuye Champions League',
            'Malava Football Festival',
            'Khwisero County Cup',
            'Butere-Mumias Derby',
            'Lugari Football Championship',
            'Navakholo United Tournament',
            'Shinyalu Stars Cup',
            'Ikolomani Football League',
            'Matungu County Championship',
            'Western Region Super Cup',
            'Mulembe Nation Tournament'
        ];
        
        $descriptions = [
            'A premier football tournament bringing together the best teams from Western Kenya.',
            'An exciting championship showcasing the finest football talent from the Luhya community.',
            'A competitive league featuring top teams from Kakamega, Bungoma, Vihiga, and Busia counties.',
            'Join us for an action-packed football tournament celebrating Western Kenya\'s rich football heritage.',
            'Experience the thrill of Western Kenya football at its best in this prestigious tournament.',
            'A celebration of football excellence featuring teams from across the Mulembe Nation.',
            'Witness the passion and skill of Western Kenya footballers in this championship.',
            'The ultimate football competition uniting teams from the Western region for glory and recognition.',
            'Bringing together communities from Kakamega and beyond in the spirit of football.',
            'A tournament honouring the legendary football tradition of Western Kenya.'
        ];
        
        return [
            'name' => $tournamentNames[array_rand($tournamentNames)] . ' ' . date('Y'),
            'description' => $descriptions[array_rand($descriptions)],
            'type' => $this->faker->randomElement(['single_elimination', 'double_elimination', 'round_robin']),
            'status' => $this->faker->randomElement(['draft', 'active', 'completed', 'cancelled']),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'max_participants' => $this->faker->randomElement([8, 16, 32, 64]),
            'entry_fee' => $this->faker->randomElement([500, 1000, 1500, 2000, 2500, 3000, 5000]), // KES amounts
            'prize_pool' => $this->faker->randomElement([10000, 25000, 50000, 100000, 250000, 500000]), // KES amounts
            'rules' => [
                'max_players_per_team' => $this->faker->numberBetween(11, 18),
                'match_duration' => 90, // Standard football match
                'elimination_type' => $this->faker->randomElement(['single', 'double']),
            ],
            'settings' => [
                'auto_start' => $this->faker->boolean(),
                'allow_spectators' => true,
                'require_verification' => $this->faker->boolean(),
            ],
        ];
    }
}
