<?php

namespace Database\Factories;

use App\Models\Tournament;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Team>
 */
class TeamFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Western Kenya - Luhya region football team names
        $teamPrefixes = [
            'AFC', 'FC', 'United', 'Rangers', 'Mulembe', 'Ingwe', 'Warriors', 'Bulls',
            'Stars', 'Lions', 'Eagles', 'Leopards', 'Heroes', 'Legends', 'Champions'
        ];
        
        $teamLocations = [
            // Kakamega County
            'Kakamega', 'Mumias', 'Butere', 'Khwisero', 'Shinyalu', 'Lurambi', 'Ikolomani', 'Lugari',
            'Malava', 'Matungu', 'Navakholo', 'Likuyani',
            // Bungoma County
            'Bungoma', 'Webuye', 'Kimilili', 'Chwele', 'Sirisia', 'Bumula', 'Kanduyi', 'Tongaren', 'Malakisi',
            // Vihiga County
            'Vihiga', 'Mbale', 'Luanda', 'Emuhaya', 'Hamisi', 'Sabatia',
            // Busia County
            'Busia', 'Malaba', 'Nambale', 'Butula', 'Funyula', 'Teso'
        ];
        
        $teamSuffixes = ['FC', 'United', 'Stars', 'Warriors', 'Rangers', 'Legends', 'Heroes', 'Bulls', 'Leopards'];
        
        $location = $teamLocations[array_rand($teamLocations)];
        $prefix = $teamPrefixes[array_rand($teamPrefixes)];
        $suffix = $teamSuffixes[array_rand($teamSuffixes)];
        
        $teamName = rand(0, 1) ? "$location $suffix" : "$prefix $location";
        
        $descriptions = [
            "A passionate football team from $location dedicated to excellence and teamwork in Western Kenya.",
            "Representing $location with pride, skill, and determination on the pitch.",
            "One of $location's finest football clubs with a rich history of success in the region.",
            "A competitive team from $location known for their attacking style and community spirit.",
            "Based in $location, we bring together talented players from across Western Kenya for victory.",
            "$location's premier football team committed to developing local talent and promoting Luhya football culture.",
            "Proudly representing the people of $location in regional and national competitions.",
            "A team built on the strong football tradition of $location and Western Kenya."
        ];
        
        return [
            'tournament_id' => Tournament::factory(),
            'name' => $teamName,
            'description' => $descriptions[array_rand($descriptions)],
            'logo' => $this->faker->imageUrl(200, 200, 'sports'),
            'captain_id' => User::factory(),
            'stats' => [
                'matches_played' => $this->faker->numberBetween(0, 50),
                'matches_won' => $this->faker->numberBetween(0, 25),
                'win_rate' => $this->faker->randomFloat(2, 0, 100),
                'total_score' => $this->faker->numberBetween(0, 500),
            ],
            'status' => $this->faker->randomElement(['active', 'eliminated', 'withdrawn']),
        ];
    }
}
