<?php

namespace Database\Factories;

use App\Models\Bracket;
use App\Models\Player;
use App\Models\Team;
use App\Models\Tournament;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\GameMatch>
 */
class GameMatchFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $scheduledTime = $this->faker->dateTimeBetween('now', '+1 month');
        
        return [
            'tournament_id' => Tournament::factory(),
            'bracket_id' => Bracket::factory(),
            'round' => $this->faker->numberBetween(1, 8),
            'match_number' => $this->faker->numberBetween(1, 100),
            'player1_id' => Player::factory(),
            'player2_id' => Player::factory(),
            'team1_id' => Team::factory(),
            'team2_id' => Team::factory(),
            'player1_score' => $this->faker->numberBetween(0, 10),
            'player2_score' => $this->faker->numberBetween(0, 10),
            'winner_id' => Player::factory(),
            'winning_team_id' => Team::factory(),
            'status' => $this->faker->randomElement(['scheduled', 'in_progress', 'completed', 'cancelled']),
            'scheduled_time' => $scheduledTime,
            'started_at' => $this->faker->optional()->dateTimeBetween($scheduledTime, '+1 hour'),
            'completed_at' => $this->faker->optional()->dateTimeBetween($scheduledTime, '+2 hours'),
        ];
    }
}
