<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Formation>
 */
class FormationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Popular football formations
        $formations = [
            [
                'name' => '4-4-2',
                'display_name' => 'Classic 4-4-2',
                'description' => 'A balanced formation with four defenders, four midfielders, and two strikers. Ideal for teams that want stability in both defense and attack.',
                'category' => 'standard',
                'is_popular' => true,
                'positions' => $this->generate442Positions(),
            ],
            [
                'name' => '4-3-3',
                'display_name' => 'Attacking 4-3-3',
                'description' => 'An attacking formation with four defenders, three midfielders, and three forwards. Great for teams that want to dominate possession and attack.',
                'category' => 'attacking',
                'is_popular' => true,
                'positions' => $this->generate433Positions(),
            ],
            [
                'name' => '4-2-3-1',
                'display_name' => 'Modern 4-2-3-1',
                'description' => 'A modern formation with four defenders, two defensive midfielders, three attacking midfielders, and one striker. Provides defensive stability with attacking options.',
                'category' => 'standard',
                'is_popular' => true,
                'positions' => $this->generate4231Positions(),
            ],
            [
                'name' => '3-5-2',
                'display_name' => 'Dynamic 3-5-2',
                'description' => 'A formation with three center backs, five midfielders, and two strikers. Offers flexibility with wing-backs providing width.',
                'category' => 'attacking',
                'is_popular' => false,
                'positions' => $this->generate352Positions(),
            ],
            [
                'name' => '5-3-2',
                'display_name' => 'Defensive 5-3-2',
                'description' => 'A defensive formation with five defenders, three midfielders, and two strikers. Ideal for teams looking to protect a lead.',
                'category' => 'defensive',
                'is_popular' => false,
                'positions' => $this->generate532Positions(),
            ],
            [
                'name' => '4-1-4-1',
                'display_name' => 'Compact 4-1-4-1',
                'description' => 'A compact formation with four defenders, one defensive midfielder, four midfielders, and one striker. Good for counter-attacking football.',
                'category' => 'defensive',
                'is_popular' => false,
                'positions' => $this->generate4141Positions(),
            ],
            [
                'name' => '3-4-3',
                'display_name' => 'Aggressive 3-4-3',
                'description' => 'An aggressive formation with three defenders, four midfielders, and three forwards. Maximizes attacking potential.',
                'category' => 'attacking',
                'is_popular' => true,
                'positions' => $this->generate343Positions(),
            ],
        ];

        $formation = $formations[array_rand($formations)];

        return [
            'name' => $formation['name'],
            'display_name' => $formation['display_name'],
            'description' => $formation['description'],
            'positions' => $formation['positions'],
            'category' => $formation['category'],
            'is_popular' => $formation['is_popular'],
            'is_active' => true,
            'country' => 'Kenya',
        ];
    }

    /**
     * Generate positions for 4-4-2 formation
     */
    private function generate442Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'LB', 'x' => 20, 'y' => 25, 'name' => 'Left Back'],
            ['position' => 'CB', 'x' => 40, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 60, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'RB', 'x' => 80, 'y' => 25, 'name' => 'Right Back'],
            ['position' => 'LM', 'x' => 20, 'y' => 50, 'name' => 'Left Midfielder'],
            ['position' => 'CM', 'x' => 40, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 60, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'RM', 'x' => 80, 'y' => 50, 'name' => 'Right Midfielder'],
            ['position' => 'ST', 'x' => 40, 'y' => 80, 'name' => 'Striker'],
            ['position' => 'ST', 'x' => 60, 'y' => 80, 'name' => 'Striker'],
        ];
    }

    /**
     * Generate positions for 4-3-3 formation
     */
    private function generate433Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'LB', 'x' => 20, 'y' => 25, 'name' => 'Left Back'],
            ['position' => 'CB', 'x' => 40, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 60, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'RB', 'x' => 80, 'y' => 25, 'name' => 'Right Back'],
            ['position' => 'CM', 'x' => 30, 'y' => 45, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 50, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 70, 'y' => 45, 'name' => 'Center Midfielder'],
            ['position' => 'LW', 'x' => 20, 'y' => 75, 'name' => 'Left Winger'],
            ['position' => 'ST', 'x' => 50, 'y' => 85, 'name' => 'Striker'],
            ['position' => 'RW', 'x' => 80, 'y' => 75, 'name' => 'Right Winger'],
        ];
    }

    /**
     * Generate positions for 4-2-3-1 formation
     */
    private function generate4231Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'LB', 'x' => 20, 'y' => 25, 'name' => 'Left Back'],
            ['position' => 'CB', 'x' => 40, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 60, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'RB', 'x' => 80, 'y' => 25, 'name' => 'Right Back'],
            ['position' => 'CDM', 'x' => 40, 'y' => 40, 'name' => 'Defensive Midfielder'],
            ['position' => 'CDM', 'x' => 60, 'y' => 40, 'name' => 'Defensive Midfielder'],
            ['position' => 'LM', 'x' => 20, 'y' => 60, 'name' => 'Left Midfielder'],
            ['position' => 'CAM', 'x' => 50, 'y' => 65, 'name' => 'Attacking Midfielder'],
            ['position' => 'RM', 'x' => 80, 'y' => 60, 'name' => 'Right Midfielder'],
            ['position' => 'ST', 'x' => 50, 'y' => 85, 'name' => 'Striker'],
        ];
    }

    /**
     * Generate positions for 3-5-2 formation
     */
    private function generate352Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'CB', 'x' => 30, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 50, 'y' => 18, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 70, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'LWB', 'x' => 15, 'y' => 45, 'name' => 'Left Wing Back'],
            ['position' => 'CM', 'x' => 35, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 50, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 65, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'RWB', 'x' => 85, 'y' => 45, 'name' => 'Right Wing Back'],
            ['position' => 'ST', 'x' => 40, 'y' => 80, 'name' => 'Striker'],
            ['position' => 'ST', 'x' => 60, 'y' => 80, 'name' => 'Striker'],
        ];
    }

    /**
     * Generate positions for 5-3-2 formation
     */
    private function generate532Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'LWB', 'x' => 15, 'y' => 25, 'name' => 'Left Wing Back'],
            ['position' => 'CB', 'x' => 35, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 50, 'y' => 18, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 65, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'RWB', 'x' => 85, 'y' => 25, 'name' => 'Right Wing Back'],
            ['position' => 'CM', 'x' => 35, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 50, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 65, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'ST', 'x' => 40, 'y' => 75, 'name' => 'Striker'],
            ['position' => 'ST', 'x' => 60, 'y' => 75, 'name' => 'Striker'],
        ];
    }

    /**
     * Generate positions for 4-1-4-1 formation
     */
    private function generate4141Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'LB', 'x' => 20, 'y' => 25, 'name' => 'Left Back'],
            ['position' => 'CB', 'x' => 40, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 60, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'RB', 'x' => 80, 'y' => 25, 'name' => 'Right Back'],
            ['position' => 'CDM', 'x' => 50, 'y' => 40, 'name' => 'Defensive Midfielder'],
            ['position' => 'LM', 'x' => 20, 'y' => 60, 'name' => 'Left Midfielder'],
            ['position' => 'CM', 'x' => 40, 'y' => 60, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 60, 'y' => 60, 'name' => 'Center Midfielder'],
            ['position' => 'RM', 'x' => 80, 'y' => 60, 'name' => 'Right Midfielder'],
            ['position' => 'ST', 'x' => 50, 'y' => 85, 'name' => 'Striker'],
        ];
    }

    /**
     * Generate positions for 3-4-3 formation
     */
    private function generate343Positions(): array
    {
        return [
            ['position' => 'GK', 'x' => 50, 'y' => 5, 'name' => 'Goalkeeper'],
            ['position' => 'CB', 'x' => 30, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 50, 'y' => 18, 'name' => 'Center Back'],
            ['position' => 'CB', 'x' => 70, 'y' => 20, 'name' => 'Center Back'],
            ['position' => 'LM', 'x' => 20, 'y' => 50, 'name' => 'Left Midfielder'],
            ['position' => 'CM', 'x' => 40, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'CM', 'x' => 60, 'y' => 50, 'name' => 'Center Midfielder'],
            ['position' => 'RM', 'x' => 80, 'y' => 50, 'name' => 'Right Midfielder'],
            ['position' => 'LW', 'x' => 25, 'y' => 80, 'name' => 'Left Winger'],
            ['position' => 'ST', 'x' => 50, 'y' => 85, 'name' => 'Striker'],
            ['position' => 'RW', 'x' => 75, 'y' => 80, 'name' => 'Right Winger'],
        ];
    }

    /**
     * Indicate that the formation is popular
     */
    public function popular(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_popular' => true,
        ]);
    }

    /**
     * Indicate that the formation is inactive
     */
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }

    /**
     * Indicate that the formation is defensive
     */
    public function defensive(): static
    {
        return $this->state(fn (array $attributes) => [
            'category' => 'defensive',
        ]);
    }

    /**
     * Indicate that the formation is attacking
     */
    public function attacking(): static
    {
        return $this->state(fn (array $attributes) => [
            'category' => 'attacking',
        ]);
    }
}
